/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.base;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStore
implements Store,
Serializable {
    protected final Set<StoreListener> storeListeners = new LinkedHashSet<StoreListener>();

    public void fireAddedEvent(String id, Object data) {
        for (StoreListener listener : this.storeListeners) {
            listener.onAdd(id, data);
        }
    }

    public void fireRemovedEvent(String id, Object data) {
        for (StoreListener listener : this.storeListeners) {
            listener.onRemove(id, data);
        }
    }

    public void fireEvictedEvent(String id, Object data) {
        for (StoreListener listener : this.storeListeners) {
            listener.onEvict(id, data);
        }
    }

    @Override
    public void addListener(StoreListener listener) {
        this.storeListeners.add(listener);
    }

    @Override
    public void removeListener(StoreListener listener) {
        this.storeListeners.remove(listener);
    }

    @Override
    public Set<StoreListener> getStoreListeners() {
        return this.storeListeners;
    }
}

