/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.osgi;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicemix.executors.impl.ExecutorConfig;
import org.apache.servicemix.executors.impl.ExecutorFactoryImpl;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorConfigurator
implements ManagedService {
    private ExecutorFactoryImpl executorFactory;

    public ExecutorFactoryImpl getExecutorFactory() {
        return this.executorFactory;
    }

    public void setExecutorFactory(ExecutorFactoryImpl factory) {
        this.executorFactory = factory;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (this.executorFactory.getDefaultConfig() == null) {
            this.executorFactory.setDefaultConfig(new ExecutorConfig(true, null));
        }
        HashMap<String, ExecutorConfig> configs = new HashMap<String, ExecutorConfig>();
        if (properties != null) {
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.endsWith(".corePoolSize")) {
                    this.getConfig(configs, key).setCorePoolSize(Integer.valueOf(this.getInt(properties, key)));
                    continue;
                }
                if (key.endsWith(".maximumPoolSize")) {
                    this.getConfig(configs, key).setMaximumPoolSize(Integer.valueOf(this.getInt(properties, key)));
                    continue;
                }
                if (key.endsWith(".keepAliveTime")) {
                    this.getConfig(configs, key).setKeepAliveTime(Long.valueOf(this.getLong(properties, key)));
                    continue;
                }
                if (key.endsWith(".threadDaemon")) {
                    this.getConfig(configs, key).setThreadDaemon(Boolean.valueOf(this.getBool(properties, key)));
                    continue;
                }
                if (key.endsWith(".threadPriority")) {
                    this.getConfig(configs, key).setThreadPriority(Integer.valueOf(this.getInt(properties, key)));
                    continue;
                }
                if (key.endsWith(".queueSize")) {
                    this.getConfig(configs, key).setQueueSize(Integer.valueOf(this.getInt(properties, key)));
                    continue;
                }
                if (key.endsWith(".shutdownDelay")) {
                    this.getConfig(configs, key).setShutdownDelay(Long.valueOf(this.getLong(properties, key)));
                    continue;
                }
                if (key.endsWith(".allowCoreThreadTimeOut")) {
                    this.getConfig(configs, key).setAllowCoreThreadTimeOut(Boolean.valueOf(this.getBool(properties, key)));
                    continue;
                }
                if (key.endsWith(".bypassIfSynchronous")) {
                    this.getConfig(configs, key).setBypassIfSynchronous(Boolean.valueOf(this.getBool(properties, key)));
                    continue;
                }
                if (key.equals("corePoolSize")) {
                    this.executorFactory.getDefaultConfig().setCorePoolSize(Integer.valueOf(this.getInt(properties, key)));
                    continue;
                }
                if (key.equals("maximumPoolSize")) {
                    this.executorFactory.getDefaultConfig().setMaximumPoolSize(Integer.valueOf(this.getInt(properties, key)));
                    continue;
                }
                if (key.equals("keepAliveTime")) {
                    this.executorFactory.getDefaultConfig().setKeepAliveTime(Long.valueOf(this.getLong(properties, key)));
                    continue;
                }
                if (key.equals("threadDaemon")) {
                    this.executorFactory.getDefaultConfig().setThreadDaemon(Boolean.valueOf(this.getBool(properties, key)));
                    continue;
                }
                if (key.equals("threadPriority")) {
                    this.executorFactory.getDefaultConfig().setThreadPriority(Integer.valueOf(this.getInt(properties, key)));
                    continue;
                }
                if (key.equals("queueSize")) {
                    this.executorFactory.getDefaultConfig().setQueueSize(Integer.valueOf(this.getInt(properties, key)));
                    continue;
                }
                if (key.equals("shutdownDelay")) {
                    this.executorFactory.getDefaultConfig().setShutdownDelay(Long.valueOf(this.getLong(properties, key)));
                    continue;
                }
                if (key.equals("allowCoreThreadTimeOut")) {
                    this.executorFactory.getDefaultConfig().setAllowCoreThreadTimeOut(Boolean.valueOf(this.getBool(properties, key)));
                    continue;
                }
                if (!key.equals("bypassIfSynchronous")) continue;
                this.executorFactory.getDefaultConfig().setBypassIfSynchronous(Boolean.valueOf(this.getBool(properties, key)));
            }
        }
        this.executorFactory.setConfigs(configs);
    }

    private ExecutorConfig getConfig(Map<String, ExecutorConfig> configs, String key) {
        String name = key.substring(0, key.lastIndexOf(46));
        ExecutorConfig config = configs.get(name);
        if (config == null) {
            config = new ExecutorConfig(false, this.executorFactory.getDefaultConfig());
            configs.put(name, config);
        }
        return config;
    }

    private int getInt(Dictionary properties, String key) {
        return Integer.parseInt(properties.get(key).toString());
    }

    private long getLong(Dictionary properties, String key) {
        return Long.parseLong(properties.get(key).toString());
    }

    private boolean getBool(Dictionary properties, String key) {
        return Boolean.parseBoolean(properties.get(key).toString());
    }
}

