/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.admin.command;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.admin.Instance;
import org.apache.karaf.admin.command.AdminCommandSupport;

@Command(scope="admin", name="list", description="Lists all existing container instances.")
public class ListCommand
extends AdminCommandSupport {
    @Option(name="-l", aliases={"--location"}, description="Displays the location of the container instances", required=false, multiValued=false)
    boolean location;
    @Option(name="-o", aliases={"--java-opts"}, description="Displays the java options used to launch the JVM", required=false, multiValued=false)
    boolean javaOpts;

    protected Object doExecute() throws Exception {
        Instance[] instances = this.getAdminService().getInstances();
        if (this.javaOpts) {
            System.out.println("  SSH Port   RMI Ports         State       Pid  JavaOpts");
        } else if (this.location) {
            System.out.println("  SSH Port   RMI Ports         State       Pid  Location");
        } else {
            System.out.println("  SSH Port   RMI Ports         State       Pid  Name");
        }
        for (Instance instance : instances) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            String s = Integer.toString(instance.getSshPort());
            for (int i = s.length(); i < 8; ++i) {
                sb.append(' ');
            }
            sb.append(s);
            sb.append("] [");
            String rmiRegistryPort = Integer.toString(instance.getRmiRegistryPort());
            String rmiServerPort = Integer.toString(instance.getRmiServerPort());
            sb.append(rmiRegistryPort).append("/").append(rmiServerPort);
            for (int i = rmiRegistryPort.length() + rmiServerPort.length() + 1; i < 15; ++i) {
                sb.append(' ');
            }
            sb.append("] [");
            String state = instance.getState();
            while (state.length() < "starting".length()) {
                state = state + " ";
            }
            sb.append(state);
            sb.append("] [");
            s = Integer.toString(instance.getPid());
            for (int i = s.length(); i < 5; ++i) {
                sb.append(' ');
            }
            sb.append(s);
            sb.append("] ");
            if (this.javaOpts) {
                sb.append(instance.getJavaOpts());
            } else if (this.location) {
                sb.append(instance.getLocation());
            } else {
                sb.append(instance.getName());
            }
            System.out.println(sb.toString());
        }
        return null;
    }
}

