/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.tools.wsdl;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.tools.wsdl.Schema;
import org.apache.servicemix.common.tools.wsdl.SchemaCollection;

public class WSDLFlattener {
    private Definition definition;
    private SchemaCollection schemas;
    private Map<QName, Definition> flattened;
    private boolean initialized;

    public WSDLFlattener() {
        this(null, null);
    }

    public WSDLFlattener(Definition definition) {
        this(definition, null);
    }

    public WSDLFlattener(Definition definition, SchemaCollection schemas) {
        this.definition = definition;
        this.flattened = new HashMap<QName, Definition>();
        this.schemas = schemas;
    }

    public void initialize() throws Exception {
        if (!this.initialized) {
            if (this.schemas == null) {
                this.schemas = new SchemaCollection(this.getUri(this.definition.getDocumentBaseURI()));
            }
            this.parseSchemas(this.definition);
            this.initialized = true;
        }
    }

    public Definition getDefinition(QName portType) throws Exception {
        Definition def = this.flattened.get(portType);
        if (def == null) {
            def = this.flattenDefinition(portType);
            this.flattened.put(portType, def);
        }
        return def;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public SchemaCollection getSchemas() throws Exception {
        return this.schemas;
    }

    public void setSchemas(SchemaCollection schemas) {
        this.schemas = schemas;
    }

    private Definition flattenDefinition(QName name) throws Exception {
        this.initialize();
        Definition flat = WSDLFactory.newInstance().newDefinition();
        flat.setTargetNamespace(name.getNamespaceURI());
        this.addNamespaces(flat, this.definition);
        PortType defPort = this.definition.getPortType(name);
        PortType flatPort = flat.createPortType();
        flatPort.setQName(defPort.getQName());
        flatPort.setUndefined(false);
        for (Operation defOper : defPort.getOperations()) {
            Operation flatOper = flat.createOperation();
            flatOper.setName(defOper.getName());
            flatOper.setStyle(defOper.getStyle());
            flatOper.setUndefined(false);
            if (defOper.getInput() != null) {
                Input flatInput = flat.createInput();
                flatInput.setName(defOper.getInput().getName());
                if (defOper.getInput().getMessage() != null) {
                    Message flatInputMsg = this.copyMessage(defOper.getInput().getMessage(), flat);
                    flatInput.setMessage(flatInputMsg);
                    flat.addMessage(flatInputMsg);
                }
                flatOper.setInput(flatInput);
            }
            if (defOper.getOutput() != null) {
                Output flatOutput = flat.createOutput();
                flatOutput.setName(defOper.getOutput().getName());
                if (defOper.getOutput().getMessage() != null) {
                    Message flatOutputMsg = this.copyMessage(defOper.getOutput().getMessage(), flat);
                    flatOutput.setMessage(flatOutputMsg);
                    flat.addMessage(flatOutputMsg);
                }
                flatOper.setOutput(flatOutput);
            }
            for (Fault defFault : defOper.getFaults().values()) {
                Fault flatFault = flat.createFault();
                flatFault.setName(defFault.getName());
                if (defFault.getMessage() != null) {
                    Message flatFaultMsg = this.copyMessage(defFault.getMessage(), flat);
                    flatFault.setMessage(flatFaultMsg);
                    flat.addMessage(flatFaultMsg);
                }
                flatOper.addFault(flatFault);
            }
            flatPort.addOperation(flatOper);
        }
        if (this.schemas.getSize() > 0) {
            Types types = flat.createTypes();
            Iterator<Schema> it = this.schemas.getSchemas().iterator();
            while (it.hasNext()) {
                SchemaImpl imp = new SchemaImpl();
                imp.setElement(it.next().getRoot());
                imp.setElementType(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
                types.addExtensibilityElement((ExtensibilityElement)imp);
            }
            flat.setTypes(types);
        }
        flat.addPortType(flatPort);
        return flat;
    }

    private void parseSchemas(Definition def) throws Exception {
        if (def.getTypes() != null && def.getTypes().getExtensibilityElements() != null) {
            for (ExtensibilityElement element : def.getTypes().getExtensibilityElements()) {
                if (!(element instanceof javax.wsdl.extensions.schema.Schema)) continue;
                javax.wsdl.extensions.schema.Schema schema = (javax.wsdl.extensions.schema.Schema)element;
                if (schema.getElement() != null) {
                    this.schemas.read(schema.getElement(), this.getUri(schema.getDocumentBaseURI()));
                }
                for (Collection imps : schema.getImports().values()) {
                    for (SchemaImport imp : imps) {
                        this.schemas.read(imp.getSchemaLocationURI(), this.getUri(def.getDocumentBaseURI()));
                    }
                }
            }
        }
        if (def.getImports() != null) {
            for (Collection imps : def.getImports().values()) {
                for (Import imp : imps) {
                    this.parseSchemas(imp.getDefinition());
                }
            }
        }
    }

    private void addNamespaces(Definition flat, Definition def) {
        for (List defImports : def.getImports().values()) {
            for (Import defImport : defImports) {
                this.addNamespaces(flat, defImport.getDefinition());
            }
        }
        for (String key : def.getNamespaces().keySet()) {
            String val = def.getNamespace(key);
            flat.addNamespace(key, val);
        }
    }

    private Message copyMessage(Message defMessage, Definition flat) {
        Message flatMsg = flat.createMessage();
        flatMsg.setUndefined(false);
        if (defMessage.getQName() != null) {
            flatMsg.setQName(new QName(flat.getTargetNamespace(), defMessage.getQName().getLocalPart()));
        }
        for (Part defPart : defMessage.getParts().values()) {
            Part flatPart = flat.createPart();
            flatPart.setName(defPart.getName());
            flatPart.setElementName(defPart.getElementName());
            flatMsg.addPart(flatPart);
        }
        return flatMsg;
    }

    private URI getUri(String str) {
        if (str != null) {
            str = str.replaceAll(" ", "%20");
            return URI.create(str);
        }
        return null;
    }
}

