/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.servicemix.jbi.commands.JbiCommandSupport;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.SharedLibrary;

@Command(scope="jbi", name="list", description="List JBI endpoints")
public class ListCommand
extends JbiCommandSupport {
    private static final int NAME_COL_LENGTH = 30;

    protected Object doExecute() throws Exception {
        List<ServiceAssembly> assemblies;
        List<Component> components;
        List<SharedLibrary> libraries = this.getSharedLibraries();
        if (libraries != null && !libraries.isEmpty()) {
            System.out.println("Shared Libraries");
            System.out.println("----------------");
            for (SharedLibrary library : libraries) {
                System.out.println(library.getName() + " - " + library.getVersion() + " - " + (library.getDescription() != null ? library.getDescription() : ""));
            }
            System.out.println();
        }
        if ((components = this.getComponents()) != null && !components.isEmpty()) {
            System.out.println("Components");
            System.out.println("----------");
            System.out.println("   State                  Name                  Description");
            for (Component component : components) {
                System.out.println("[" + this.getStateString(component.getCurrentState()) + "] [" + this.getNameString(component.getName(), 30) + "]     " + (component.getDescription() != null ? component.getDescription() : ""));
            }
            System.out.println();
        }
        if ((assemblies = this.getServiceAssemblies()) != null && !assemblies.isEmpty()) {
            System.out.println("Service Assemblies");
            System.out.println("------------------");
            System.out.println("   State                  Name                  Description");
            for (ServiceAssembly assembly : assemblies) {
                System.out.println("[" + this.getStateString(assembly.getCurrentState()) + "] [" + this.getNameString(assembly.getName(), 30) + "]     " + (assembly.getDescription() != null ? assembly.getDescription() : ""));
            }
            System.out.println();
        }
        return null;
    }

    private String getNameString(String name, int colLength) {
        String ret = name;
        for (int i = 0; i < colLength - name.length(); ++i) {
            ret = ret + " ";
        }
        return ret;
    }

    private String getStateString(String state) {
        if (state.equals("Shutdown")) {
            return "Shutdown";
        }
        if (state.equals("Started")) {
            return "Started ";
        }
        if (state.equals("Stopped")) {
            return "Stopped ";
        }
        return "Unknown ";
    }
}

