/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.jbi.JBIException;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.deployer.artifacts.AbstractLifecycleJbiArtifact;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.handler.Transformer;
import org.apache.servicemix.jbi.deployer.impl.Deployer;
import org.apache.servicemix.jbi.deployer.impl.Storage;
import org.apache.servicemix.jbi.deployer.utils.FileUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstaller {
    public static final String LAST_INSTALL = "jbi.deployer.install";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Deployer deployer;
    protected Descriptor descriptor;
    protected Bundle bundle;
    protected boolean autoStart = false;
    protected File jbiArtifact;
    protected File installRoot;
    protected boolean uninstallFromOsgi;
    protected boolean isFirstInstall;
    protected boolean isModified;

    protected AbstractInstaller(Deployer deployer, Descriptor descriptor, File jbiArtifact, boolean autoStart) {
        this.deployer = deployer;
        this.descriptor = descriptor;
        this.jbiArtifact = jbiArtifact;
        this.autoStart = autoStart;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    protected BundleContext getBundleContext() {
        return this.deployer.getBundleContext();
    }

    public abstract String getName();

    public void init() throws Exception {
        Storage storage = this.getStorage();
        long lastInstall = Long.parseLong(storage.get(LAST_INSTALL, "0"));
        this.isFirstInstall = lastInstall == 0L;
        boolean bl = this.isModified = lastInstall == 0L || this.getBundle().getLastModified() > lastInstall;
        if (this.isModified && this.installRoot != null) {
            this.extractBundle(this.installRoot, this.getBundle(), "/");
            lastInstall = this.getBundle().getLastModified();
            storage.put("state", this.isAutoStart() ? AbstractLifecycleJbiArtifact.State.Started.name() : AbstractLifecycleJbiArtifact.State.Shutdown.name());
        }
    }

    protected void postInstall() throws Exception {
        Storage prefs = this.getStorage();
        prefs.put(LAST_INSTALL, Long.toString(this.getBundle().getLastModified()));
        prefs.save();
    }

    public abstract ObjectName install() throws JBIException;

    public abstract void stop(boolean var1) throws Exception;

    public abstract void uninstall(boolean var1) throws Exception;

    public void installBundle() throws Exception {
        InputStream is = null;
        try {
            this.deployer.setJmxManaged(this);
            File artifact = new File(this.jbiArtifact.getCanonicalPath());
            String bundleName = artifact.getName().substring(0, artifact.getName().length() - 4) + ".jar";
            File osgi = new File(this.getGenerateDir(), bundleName);
            Transformer.transformToOSGiBundle(artifact, osgi);
            is = new BufferedInputStream(new FileInputStream(osgi));
            this.bundle = this.getBundleContext().installBundle(artifact.getCanonicalFile().toURI().toString(), is);
            this.bundle.start();
        }
        catch (Exception e) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException io) {
                    this.logger.info("Failed to close stream.", (Throwable)io);
                }
            }
            throw e;
        }
        finally {
            this.deployer.setJmxManaged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallBundle() throws BundleException {
        if (this.bundle != null && this.bundle.getState() != 1 && !this.uninstallFromOsgi) {
            try {
                this.deployer.setJmxManaged(this);
                this.bundle.uninstall();
            }
            finally {
                this.deployer.setJmxManaged(null);
            }
        }
    }

    private File getGenerateDir() {
        String base = System.getProperty("servicemix.base", ".");
        return new File(base, "data/generated-bundles");
    }

    protected Storage getStorage() {
        return this.deployer.getStorage(this.getName());
    }

    protected void deleteStorage() throws IOException {
        Storage storage = this.getStorage();
        storage.clear();
        storage.save();
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isUninstallFromOsgi() {
        return this.uninstallFromOsgi;
    }

    public void setUninstallFromOsgi(boolean uninstallFromOsgi) {
        this.uninstallFromOsgi = uninstallFromOsgi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractBundle(File installRoot, Bundle bundle, String path) throws IOException {
        Enumeration e = bundle.getEntryPaths(path);
        while (e != null && e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            File fout = new File(installRoot, entry);
            if (entry.endsWith("/")) {
                fout.mkdirs();
                this.extractBundle(installRoot, bundle, entry);
                continue;
            }
            InputStream in = bundle.getEntry(entry).openStream();
            FileOutputStream out = new FileOutputStream(fout);
            try {
                FileUtil.copyInputStream(in, out);
            }
            finally {
                in.close();
                ((OutputStream)out).close();
            }
        }
    }
}

