/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.util.HashSet;
import javax.jbi.management.AdminServiceMBean;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.deployer.artifacts.ComponentImpl;
import org.apache.servicemix.jbi.deployer.impl.Deployer;

public class AdminService
implements AdminServiceMBean {
    public static final String DEFAULT_NAME = "ServiceMix";
    public static final String DEFAULT_DOMAIN = "org.apache.servicemix";
    public static final String DEFAULT_CONNECTOR_PATH = "/karaf-root";
    public static final int DEFAULT_CONNECTOR_PORT = 1099;
    private Deployer deployer;

    public Deployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public ObjectName[] getBindingComponents() {
        HashSet<ObjectName> names = new HashSet<ObjectName>();
        for (ComponentImpl component : this.deployer.getComponents().values()) {
            if (!"binding-component".equals(component.getMainType())) continue;
            try {
                names.add(this.deployer.getEnvironment().getManagedObjectName((Object)component));
            }
            catch (Exception e) {}
        }
        return names.toArray(new ObjectName[names.size()]);
    }

    public ObjectName getComponentByName(String name) {
        ComponentImpl component = this.deployer.getComponent(name);
        if (component != null) {
            try {
                return this.deployer.getEnvironment().getManagedObjectName((Object)component);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public ObjectName[] getEngineComponents() {
        HashSet<ObjectName> names = new HashSet<ObjectName>();
        for (ComponentImpl component : this.deployer.getComponents().values()) {
            if (!"service-engine".equals(component.getMainType())) continue;
            try {
                names.add(this.deployer.getEnvironment().getManagedObjectName((Object)component));
            }
            catch (Exception e) {}
        }
        return names.toArray(new ObjectName[names.size()]);
    }

    public String getSystemInfo() {
        return "ServiceMix 4";
    }

    public ObjectName getSystemService(String serviceName) {
        return null;
    }

    public ObjectName[] getSystemServices() {
        return new ObjectName[0];
    }

    public boolean isBinding(String componentName) {
        ComponentImpl component = this.deployer.getComponent(componentName);
        return component != null && "binding-component".equals(component.getMainType());
    }

    public boolean isEngine(String componentName) {
        ComponentImpl component = this.deployer.getComponent(componentName);
        return component != null && "service-engine".equals(component.getMainType());
    }
}

