/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.commands;

import java.util.List;
import javax.jbi.management.LifeCycleMBean;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;
import org.apache.servicemix.jbi.commands.JbiCommandSupport;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;

public abstract class JbiLifeCycleCommandSupport
extends JbiCommandSupport {
    @Option(name="-c", aliases={"--component"}, description="a component")
    boolean isComponent;
    @Option(name="-a", aliases={"--service-assembly"}, description="a service assembly")
    boolean isAssembly;
    @Argument(required=true, multiValued=true)
    List<String> artifacts;

    protected Object doExecute() throws Exception {
        if (this.isComponent && this.isAssembly) {
            throw new IllegalArgumentException("Can not specify options -c and -a at the same time!");
        }
        for (String artifact : this.artifacts) {
            try {
                ServiceAssembly assembly;
                Component component;
                if ((!this.isComponent && !this.isAssembly || this.isComponent) && (component = this.getComponent(artifact)) != null) {
                    this.handle((LifeCycleMBean)component);
                    continue;
                }
                if ((!this.isComponent && !this.isAssembly || this.isAssembly) && (assembly = this.getServiceAssembly(artifact)) != null) {
                    this.handle((LifeCycleMBean)assembly);
                    continue;
                }
                System.out.println("Artifact " + artifact + " not found");
            }
            catch (Exception e) {
                System.out.println("Error processing " + artifact + ": " + e);
            }
        }
        return null;
    }

    protected abstract void handle(LifeCycleMBean var1) throws Exception;
}

