/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.RolePrincipal;
import org.apache.karaf.jaas.modules.UserPrincipal;

@Command(scope="jaas", name="userlist", description="Lists the users of the active realm/module.")
public class ListUsersCommand
extends JaasCommandSupport {
    private static final String OUTPUT_FORMAT = "%-20s %-20s";

    protected Object doExecute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (realm == null || entry == null) {
            System.err.println("No JAAS Realm / Module has been selected.");
            return null;
        }
        BackingEngine engine = this.backingEngineService.get(entry);
        if (engine == null) {
            System.err.println(String.format("Failed to resolve backing engine for realm:%s and moudle:%s", realm.getName(), entry.getLoginModuleName()));
            return null;
        }
        return this.doExecute(engine);
    }

    protected Object doExecute(BackingEngine engine) throws Exception {
        List users = engine.listUsers();
        System.out.println(String.format(OUTPUT_FORMAT, "User Name", "Role"));
        for (UserPrincipal user : users) {
            String userName = user.getName();
            List roles = engine.listRoles(user);
            if (roles != null && roles.size() >= 1) {
                for (RolePrincipal role : roles) {
                    String roleName = role.getName();
                    System.out.println(String.format(OUTPUT_FORMAT, userName, roleName));
                }
                continue;
            }
            System.out.println(String.format(OUTPUT_FORMAT, userName, ""));
        }
        return null;
    }
}

