/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.commands;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.servicemix.nmr.audit.AuditorMBean;
import org.apache.servicemix.nmr.audit.commands.AuditCommandSupport;

@Command(scope="audit", name="delete", description="Display exchanges.")
public class DeleteCommand
extends AuditCommandSupport {
    @Option(name="--index", required=true)
    int index = -1;
    @Option(name="--id", required=true)
    String id;
    @Option(name="--all")
    boolean all;

    protected Object doExecute(AuditorMBean auditor) throws Exception {
        int nb;
        if (this.index >= 0) {
            nb = auditor.deleteExchangeByIndex(this.index) ? 1 : 0;
        } else if (this.id != null) {
            nb = auditor.deleteExchangeById(this.id) ? 1 : 0;
        } else if (this.all) {
            nb = auditor.deleteAllExchanges();
        } else {
            System.err.println("One of [--index, --id, --all] option must be specified");
            return null;
        }
        System.out.println(nb + " exchanges deleted");
        return null;
    }
}

