/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.service.internal.PaxLoggerImpl;

public class JdkHandler
extends Handler {
    private PaxLoggingService m_logService;

    public JdkHandler(PaxLoggingService logService) {
        this.m_logService = logService;
        this.setFormatter(new SimpleFormatter());
    }

    public void close() throws SecurityException {
    }

    public void flush() {
    }

    public void publish(LogRecord record) {
        String message;
        Level level = record.getLevel();
        String loggerName = record.getLoggerName();
        String fqcn = Logger.class.getName();
        PaxLoggerImpl logger = (PaxLoggerImpl)this.m_logService.getLogger(null, loggerName, fqcn);
        try {
            message = this.getFormatter().formatMessage(record);
        }
        catch (Exception ex) {
            message = record.getMessage();
        }
        Throwable throwable = record.getThrown();
        int levelInt = level.intValue();
        org.apache.log4j.Level log4jlevel = levelInt <= Level.FINEST.intValue() ? org.apache.log4j.Level.TRACE : (levelInt <= Level.FINE.intValue() ? org.apache.log4j.Level.DEBUG : (levelInt <= Level.INFO.intValue() ? org.apache.log4j.Level.INFO : (levelInt <= Level.WARNING.intValue() ? org.apache.log4j.Level.WARN : (levelInt <= Level.SEVERE.intValue() ? org.apache.log4j.Level.ERROR : org.apache.log4j.Level.OFF))));
        logger.log(log4jlevel, message, throwable);
    }
}

