/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.management.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.management.FeaturesServiceMBean;
import org.apache.karaf.features.management.codec.JmxFeature;
import org.apache.karaf.features.management.codec.JmxFeatureEvent;
import org.apache.karaf.features.management.codec.JmxRepository;
import org.apache.karaf.features.management.codec.JmxRepositoryEvent;
import org.apache.karaf.features.management.internal.StandardEmitterMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class FeaturesServiceMBeanImpl
extends StandardEmitterMBean
implements MBeanRegistration,
FeaturesServiceMBean {
    private ServiceRegistration registration;
    private BundleContext bundleContext;
    private ObjectName objectName;
    private volatile long sequenceNumber = 0L;
    private MBeanServer server;
    private FeaturesService featuresService;

    public FeaturesServiceMBeanImpl() throws NotCompliantMBeanException {
        super((Class)FeaturesServiceMBean.class);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.objectName = name;
        this.server = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        this.registration = this.bundleContext.registerService(FeaturesListener.class.getName(), (Object)this.getFeaturesListener(), new Hashtable());
    }

    public void preDeregister() throws Exception {
        this.registration.unregister();
    }

    public void postDeregister() {
    }

    public TabularData getFeatures() throws Exception {
        try {
            List<Feature> allFeatures = Arrays.asList(this.featuresService.listFeatures());
            List<Feature> insFeatures = Arrays.asList(this.featuresService.listInstalledFeatures());
            ArrayList<JmxFeature> features = new ArrayList<JmxFeature>();
            for (Feature feature : allFeatures) {
                features.add(new JmxFeature(feature, insFeatures.contains(feature)));
            }
            TabularData table = JmxFeature.tableFrom(features);
            return table;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public TabularData getRepositories() throws Exception {
        try {
            List<Repository> allRepositories = Arrays.asList(this.featuresService.listRepositories());
            ArrayList<JmxRepository> repositories = new ArrayList<JmxRepository>();
            for (Repository repository : allRepositories) {
                repositories.add(new JmxRepository(repository));
            }
            TabularData table = JmxRepository.tableFrom(repositories);
            return table;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void addRepository(String uri) throws Exception {
        this.featuresService.addRepository(new URI(uri));
    }

    public void removeRepository(String uri) throws Exception {
        this.featuresService.removeRepository(new URI(uri));
    }

    public void installFeature(String name) throws Exception {
        this.featuresService.installFeature(name);
    }

    public void installFeature(String name, String version) throws Exception {
        this.featuresService.installFeature(name, version);
    }

    public void uninstallFeature(String name) throws Exception {
        this.featuresService.uninstallFeature(name);
    }

    public void uninstallFeature(String name, String version) throws Exception {
        this.featuresService.uninstallFeature(name, version);
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public FeaturesListener getFeaturesListener() {
        return new FeaturesListener(){

            public void featureEvent(FeatureEvent event) {
                if (!event.isReplay()) {
                    Notification notification = new Notification("org.apache.karaf.features.featureEvent", FeaturesServiceMBeanImpl.this.objectName, FeaturesServiceMBeanImpl.this.sequenceNumber++);
                    notification.setUserData(new JmxFeatureEvent(event).asCompositeData());
                    FeaturesServiceMBeanImpl.this.sendNotification(notification);
                }
            }

            public void repositoryEvent(RepositoryEvent event) {
                if (!event.isReplay()) {
                    Notification notification = new Notification("org.apache.karaf.features.repositoryEvent", FeaturesServiceMBeanImpl.this.objectName, FeaturesServiceMBeanImpl.this.sequenceNumber++);
                    notification.setUserData(new JmxRepositoryEvent(event).asCompositeData());
                    FeaturesServiceMBeanImpl.this.sendNotification(notification);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o.equals(this);
            }
        };
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return FeaturesServiceMBeanImpl.getBroadcastInfo();
    }

    private static MBeanNotificationInfo[] getBroadcastInfo() {
        String type = Notification.class.getCanonicalName();
        MBeanNotificationInfo info1 = new MBeanNotificationInfo(new String[]{"Type"}, type, "Some features notification");
        MBeanNotificationInfo info2 = new MBeanNotificationInfo(new String[]{"Type"}, type, "Some repository notification");
        return new MBeanNotificationInfo[]{info1, info2};
    }
}

