/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.features;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.karaf.util.DeployerUtils;

public class FeatureTransformer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(URL url, OutputStream os) throws Exception {
        String name = url.getPath();
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        String[] str = DeployerUtils.extractNameVersionType(name);
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "2");
        m.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        m.getMainAttributes().putValue("Bundle-SymbolicName", str[0]);
        m.getMainAttributes().putValue("Bundle-Version", str[1]);
        JarOutputStream out = new JarOutputStream(os);
        ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
        out.putNextEntry(e);
        m.write(out);
        out.closeEntry();
        e = new ZipEntry("META-INF/");
        out.putNextEntry(e);
        e = new ZipEntry("META-INF/org.apache.karaf.shell.features/");
        out.putNextEntry(e);
        out.closeEntry();
        e = new ZipEntry("META-INF/org.apache.karaf.shell.features/" + name);
        out.putNextEntry(e);
        InputStream fis = url.openStream();
        try {
            FeatureTransformer.copyInputStream(fis, out);
        }
        finally {
            fis.close();
        }
        out.closeEntry();
        out.close();
        os.close();
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }
}

