/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.util.Collections;
import java.util.Map;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.internal.InternalChannel;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.core.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalEndpointWrapper
implements InternalEndpoint {
    private final Endpoint endpoint;
    private final String id;
    private final Map<String, ?> metadata;
    private InternalChannel channel;

    public InternalEndpointWrapper(Endpoint endpoint, Map<String, ?> metadata) {
        this.endpoint = endpoint;
        this.metadata = metadata;
        this.id = UuidGenerator.getUUID();
    }

    public InternalChannel getChannel() {
        return this.channel;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, ?> getMetaData() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public void setChannel(Channel channel) {
        this.channel = (InternalChannel)channel;
        this.endpoint.setChannel(channel);
    }

    public void process(Exchange exchange) {
        this.endpoint.process(exchange);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalEndpointWrapper)) {
            return false;
        }
        InternalEndpointWrapper that = (InternalEndpointWrapper)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

