/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.servicemix.nmr.api.ServiceMixException;
import org.apache.servicemix.nmr.api.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistryImpl<T>
implements ServiceRegistry<T> {
    private ConcurrentMap<T, Map<String, ?>> registry = new ConcurrentHashMap();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void register(T service, Map<String, ?> properties) {
        assert (service != null) : "service should not be null";
        if (properties == null) {
            properties = new HashMap();
        }
        if (this.registry.putIfAbsent(service, properties) == null) {
            try {
                this.doRegister(service, properties);
            }
            catch (Exception e) {
                this.logger.warn("Unable to register service " + service + " with properties " + properties + ". Reason: " + e, (Throwable)e);
                this.registry.remove(service);
                throw new ServiceMixException("Unable to register service " + service + " with properties " + properties + ". Reason: " + e, (Throwable)e);
            }
        }
    }

    protected void doRegister(T service, Map<String, ?> properties) throws Exception {
    }

    public void unregister(T service, Map<String, ?> properties) {
        assert (service != null) : "service should not be null";
        if (service != null && this.registry.remove(service) != null) {
            try {
                this.doUnregister(service, properties);
            }
            catch (Exception e) {
                this.logger.warn("Unable to unregister service " + service + " with properties " + properties + ". Reason: " + e, (Throwable)e);
                throw new ServiceMixException("Unable to unregister service " + service + " with properties " + properties + ". Reason: " + e, (Throwable)e);
            }
        }
    }

    protected void doUnregister(T service, Map<String, ?> properties) throws Exception {
    }

    public Set<T> getServices() {
        return this.registry.keySet();
    }

    public Map<String, ?> getProperties(T service) {
        return (Map)this.registry.get(service);
    }
}

