/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.wrap;

import java.io.File;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.karaf.util.DeployerUtils;

public class WrapDeploymentListener
implements ArtifactUrlTransformer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canHandle(File artifact) {
        try {
            if (!artifact.getPath().endsWith(".jar")) {
                return false;
            }
            JarFile jar = new JarFile(artifact);
            try {
                Manifest manifest = jar.getManifest();
                if (manifest != null && manifest.getMainAttributes().getValue(new Attributes.Name("Bundle-SymbolicName")) != null && manifest.getMainAttributes().getValue(new Attributes.Name("Bundle-Version")) != null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                jar.close();
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public URL transform(URL artifact) throws Exception {
        try {
            String path = artifact.getPath();
            String name = path.substring(path.lastIndexOf(47) + 1);
            String[] nv = DeployerUtils.extractNameVersionType(name);
            return new URL("wrap", null, artifact.toExternalForm() + "$Bundle-SymbolicName=" + nv[0] + "&Bundle-Version=" + nv[1]);
        }
        catch (Exception e) {
            return new URL("wrap", null, artifact.toExternalForm());
        }
    }
}

