/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class ConfigCommandSupport
extends OsgiCommandSupport {
    public static final String PROPERTY_CONFIG_PID = "ConfigCommand.PID";
    public static final String PROPERTY_CONFIG_PROPS = "ConfigCommand.Props";
    private static final String PID_FILTER = "(service.pid=%s*)";
    private static final String FILE_PREFIX = "file:";
    private static final String CONFIG_SUFFIX = ".cfg";
    private static final String FACTORY_SEPARATOR = "-";
    private static final String FILEINSTALL_FILE_NAME = "felix.fileinstall.filename";
    private File storage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        if (ref == null) {
            System.out.println("ConfigurationAdmin service is unavailable.");
            return null;
        }
        try {
            ConfigurationAdmin admin = (ConfigurationAdmin)this.getBundleContext().getService(ref);
            if (admin == null) {
                System.out.println("ConfigAdmin service is unavailable.");
                Object var3_3 = null;
                return var3_3;
            }
            this.doExecute(admin);
        }
        finally {
            this.getBundleContext().ungetService(ref);
        }
        return null;
    }

    protected Dictionary getEditedProps() throws Exception {
        return (Dictionary)this.session.get(PROPERTY_CONFIG_PROPS);
    }

    protected abstract void doExecute(ConfigurationAdmin var1) throws Exception;

    public Configuration findConfigurationByFileName(ConfigurationAdmin admin, String fileName) throws IOException, InvalidSyntaxException {
        if (fileName != null && fileName.contains(FACTORY_SEPARATOR)) {
            String factoryPid = fileName.substring(0, fileName.lastIndexOf(FACTORY_SEPARATOR));
            String absoluteFileName = FILE_PREFIX + this.storage.getAbsolutePath() + File.separator + fileName + CONFIG_SUFFIX;
            Configuration[] configurations = admin.listConfigurations(String.format(PID_FILTER, factoryPid));
            if (configurations != null) {
                for (Configuration configuration : configurations) {
                    String fileInstallFileName;
                    Dictionary dictionary = configuration.getProperties();
                    if (dictionary == null || !absoluteFileName.equals(fileInstallFileName = (String)dictionary.get(FILEINSTALL_FILE_NAME))) continue;
                    return configuration;
                }
            }
        }
        return null;
    }

    public File getStorage() {
        return this.storage;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }
}

