/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.aries.blueprint.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.container.GenericType;
import org.apache.aries.blueprint.di.ExecutionContext;
import org.osgi.framework.BundleReference;
import org.osgi.service.blueprint.container.ComponentDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static Map<Class<?>, PropertyDescriptor[][]> beanInfos = Collections.synchronizedMap(new WeakHashMap());

    public static boolean hasDefaultConstructor(Class type) {
        Constructor<?>[] constructors;
        if (!Modifier.isPublic(type.getModifiers())) {
            return false;
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return false;
        }
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getImplementedInterfaces(Set<String> classes, Class clazz) {
        if (clazz != null && clazz != Object.class) {
            for (Class<?> itf : clazz.getInterfaces()) {
                if (Modifier.isPublic(itf.getModifiers())) {
                    classes.add(itf.getName());
                }
                ReflectionUtils.getImplementedInterfaces(classes, itf);
            }
            ReflectionUtils.getImplementedInterfaces(classes, clazz.getSuperclass());
        }
        return classes;
    }

    public static Set<String> getSuperClasses(Set<String> classes, Class clazz) {
        if (clazz != null && clazz != Object.class) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                classes.add(clazz.getName());
            }
            ReflectionUtils.getSuperClasses(classes, clazz.getSuperclass());
        }
        return classes;
    }

    public static Method getLifecycleMethod(Class clazz, String name) {
        if (name != null) {
            try {
                Method method = clazz.getMethod(name, new Class[0]);
                if (Void.TYPE.equals(method.getReturnType())) {
                    return method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Method> findCompatibleMethods(Class clazz, String name, Class[] paramTypes) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            Class<?>[] methodParams = method.getParameterTypes();
            if (!name.equals(method.getName()) || !Void.TYPE.equals(method.getReturnType()) || methodParams.length != paramTypes.length || method.isBridge()) continue;
            boolean assignable = true;
            for (int i = 0; i < paramTypes.length && assignable; assignable &= paramTypes[i] == null || methodParams[i].isAssignableFrom(paramTypes[i]), ++i) {
            }
            if (!assignable) continue;
            methods.add(method);
        }
        return methods;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz, boolean allowFieldInjection) {
        int index;
        PropertyDescriptor[][] properties = beanInfos.get(clazz);
        int n = index = allowFieldInjection ? 0 : 1;
        if (properties == null) {
            properties = new PropertyDescriptor[2][];
            beanInfos.put(clazz, properties);
        }
        if (properties[index] == null) {
            HashSet<String> propertyNames = new HashSet<String>();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap setters = new HashMap();
            HashSet<String> illegalProperties = new HashSet<String>();
            for (Method method : clazz.getMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || method.isBridge()) continue;
                String name = method.getName();
                Class<?>[] argTypes = method.getParameterTypes();
                Class<?> resultType = method.getReturnType();
                if (name.length() > 3 && name.startsWith("set") && resultType == Void.TYPE && argTypes.length == 1) {
                    if (!setters.containsKey(name = ReflectionUtils.decapitalize(name.substring(3)))) {
                        setters.put(name, new ArrayList());
                    }
                    ((List)setters.get(name)).add(method);
                    propertyNames.add(name);
                    continue;
                }
                if (name.length() > 3 && name.startsWith("get") && resultType != Void.TYPE && argTypes.length == 0) {
                    if (getters.containsKey(name = ReflectionUtils.decapitalize(name.substring(3)))) {
                        illegalProperties.add(name);
                    } else {
                        propertyNames.add(name);
                    }
                    getters.put(name, method);
                    continue;
                }
                if (name.length() <= 2 || !name.startsWith("is") || argTypes.length != 0 || resultType != Boolean.TYPE) continue;
                if (getters.containsKey(name = ReflectionUtils.decapitalize(name.substring(2)))) {
                    illegalProperties.add(name);
                } else {
                    propertyNames.add(name);
                }
                getters.put(name, method);
            }
            HashMap<String, PropertyDescriptor> props = new HashMap<String, PropertyDescriptor>();
            for (String propName : propertyNames) {
                props.put(propName, new MethodPropertyDescriptor(propName, (Method)getters.get(propName), (Collection)setters.get(propName)));
            }
            if (allowFieldInjection) {
                for (Class cl = clazz; cl != null && cl != Object.class; cl = cl.getSuperclass()) {
                    for (Field field : cl.getDeclaredFields()) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        String name = ReflectionUtils.decapitalize(field.getName());
                        PropertyDescriptor desc = (PropertyDescriptor)props.get(name);
                        if (desc == null) {
                            props.put(name, new FieldPropertyDescriptor(name, field));
                            continue;
                        }
                        if (desc instanceof MethodPropertyDescriptor) {
                            props.put(name, new JointPropertyDescriptor((MethodPropertyDescriptor)desc, new FieldPropertyDescriptor(name, field)));
                            continue;
                        }
                        illegalProperties.add(name);
                    }
                }
            }
            ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
            for (PropertyDescriptor prop : props.values()) {
                if (illegalProperties.contains(prop.getName())) continue;
                result.add(prop);
            }
            properties[index] = result.toArray(new PropertyDescriptor[result.size()]);
        }
        return properties[index];
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static Object invoke(AccessControlContext acc, final Method method, final Object instance, final Object ... args) throws Exception {
        if (acc == null) {
            return method.invoke(instance, args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return method.invoke(instance, args);
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Object newInstance(AccessControlContext acc, final Class clazz) throws Exception {
        if (acc == null) {
            return clazz.newInstance();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return clazz.newInstance();
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Object newInstance(AccessControlContext acc, final Constructor constructor, final Object ... args) throws Exception {
        if (acc == null) {
            return constructor.newInstance(args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return constructor.newInstance(args);
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Throwable getRealCause(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodPropertyDescriptor
    extends PropertyDescriptor {
        private final Method getter;
        private final Collection<Method> setters;

        private MethodPropertyDescriptor(String name, Method getter, Collection<Method> setters) {
            super(name);
            this.getter = getter;
            this.setters = setters != null ? setters : Collections.emptyList();
        }

        @Override
        public boolean allowsGet() {
            return this.getter != null;
        }

        @Override
        public boolean allowsSet() {
            return !this.setters.isEmpty();
        }

        @Override
        protected Object internalGet(ExtendedBlueprintContainer container, Object instance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.getter != null) {
                return this.getter.invoke(instance, new Object[0]);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        protected void internalSet(ExtendedBlueprintContainer container, Object instance, Object value) throws Exception {
            Method setterMethod = this.findSetter(value);
            if (setterMethod == null) {
                throw new ComponentDefinitionException("No converter available to convert value " + value + " into a form applicable for the " + "setters of property " + this.getName());
            }
            setterMethod.invoke(instance, this.convert(value, setterMethod.getGenericParameterTypes()[0]));
        }

        private Method findSetter(Object value) {
            Class<?> valueType = value == null ? null : value.getClass();
            Method result = this.findMethodByClass(valueType);
            if (result == null) {
                result = this.findMethodWithConversion(value);
            }
            return result;
        }

        private Method findMethodByClass(Class<?> arg) throws ComponentDefinitionException {
            Method result = null;
            if (!this.hasSameTypeSetter()) {
                throw new ComponentDefinitionException("At least one Setter method has to match the type of the Getter method for property " + this.getName());
            }
            if (this.setters.size() == 1) {
                return this.setters.iterator().next();
            }
            for (Method m : this.setters) {
                Class<?> paramType = m.getParameterTypes()[0];
                if ((arg != null || !Object.class.isAssignableFrom(paramType)) && (arg == null || !paramType.isAssignableFrom(arg))) continue;
                if (result != null) {
                    Class<?> oldParamType = result.getParameterTypes()[0];
                    if (paramType.isAssignableFrom(oldParamType)) continue;
                    if (oldParamType.isAssignableFrom(paramType)) {
                        result = m;
                        continue;
                    }
                    throw new ComponentDefinitionException("Ambiguous setter method for property " + this.getName() + ". More than one method matches the  parameter type " + arg);
                }
                result = m;
            }
            return result;
        }

        private boolean hasSameTypeSetter() {
            if (this.getter == null) {
                return true;
            }
            for (Method m : this.setters) {
                if (!m.getParameterTypes()[0].equals(this.getter.getReturnType())) continue;
                return true;
            }
            return false;
        }

        private Method findMethodWithConversion(Object value) throws ComponentDefinitionException {
            ExecutionContext ctx = ExecutionContext.Holder.getContext();
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            for (Method m : this.setters) {
                Type paramType = m.getGenericParameterTypes()[0];
                if (!ctx.canConvert(value, new GenericType(paramType))) continue;
                matchingMethods.add(m);
            }
            if (matchingMethods.isEmpty()) {
                return null;
            }
            if (matchingMethods.size() == 1) {
                return (Method)matchingMethods.get(0);
            }
            throw new ComponentDefinitionException("Ambiguous setter method for property " + this.getName() + ". More than one method matches the parameter " + value + " after applying conversion.");
        }

        public String toString() {
            return "PropertyDescriptor <name: " + this.getName() + ", getter: " + this.getter + ", setter: " + this.setters;
        }
    }

    private static class FieldPropertyDescriptor
    extends PropertyDescriptor {
        private final Field field;

        public FieldPropertyDescriptor(String name, Field field) {
            super(name);
            this.field = field;
        }

        public boolean allowsGet() {
            return true;
        }

        public boolean allowsSet() {
            return true;
        }

        protected Object internalGet(ExtendedBlueprintContainer container, final Object instance) throws IllegalArgumentException, IllegalAccessException {
            if (this.useContainersPermission(container)) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            FieldPropertyDescriptor.this.field.setAccessible(true);
                            return FieldPropertyDescriptor.this.field.get(instance);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    if (e instanceof IllegalAccessException) {
                        throw (IllegalAccessException)e;
                    }
                    throw (RuntimeException)e;
                }
            }
            this.field.setAccessible(true);
            return this.field.get(instance);
        }

        protected void internalSet(ExtendedBlueprintContainer container, final Object instance, Object value) throws Exception {
            final Object convertedValue = this.convert(value, this.field.getGenericType());
            if (this.useContainersPermission(container)) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            FieldPropertyDescriptor.this.field.setAccessible(true);
                            FieldPropertyDescriptor.this.field.set(instance, convertedValue);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            } else {
                this.field.setAccessible(true);
                this.field.set(instance, convertedValue);
            }
        }

        private boolean useContainersPermission(ExtendedBlueprintContainer container) {
            ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return FieldPropertyDescriptor.this.field.getDeclaringClass().getClassLoader();
                }
            });
            if (loader == null) {
                return false;
            }
            if (loader instanceof BundleReference) {
                BundleReference ref = (BundleReference)loader;
                return ref.getBundle().equals(container.getBundleContext().getBundle());
            }
            return false;
        }
    }

    private static class JointPropertyDescriptor
    extends PropertyDescriptor {
        private final MethodPropertyDescriptor mpd;
        private final FieldPropertyDescriptor fpd;

        public JointPropertyDescriptor(MethodPropertyDescriptor mpd, FieldPropertyDescriptor fpd) {
            super(mpd.getName());
            this.mpd = mpd;
            this.fpd = fpd;
        }

        public boolean allowsGet() {
            return this.mpd.allowsGet() || this.fpd.allowsGet();
        }

        public boolean allowsSet() {
            return this.mpd.allowsSet() || this.fpd.allowsSet();
        }

        protected Object internalGet(ExtendedBlueprintContainer container, Object instance) throws Exception {
            if (this.mpd.allowsGet()) {
                return this.mpd.internalGet(container, instance);
            }
            if (this.fpd.allowsGet()) {
                return this.fpd.internalGet(container, instance);
            }
            throw new UnsupportedOperationException();
        }

        protected void internalSet(ExtendedBlueprintContainer container, Object instance, Object value) throws Exception {
            if (this.mpd.allowsSet()) {
                this.mpd.internalSet(container, instance, value);
            } else if (this.fpd.allowsSet()) {
                this.fpd.internalSet(container, instance, value);
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static abstract class PropertyDescriptor {
        private final String name;

        public PropertyDescriptor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract boolean allowsGet();

        public abstract boolean allowsSet();

        protected abstract Object internalGet(ExtendedBlueprintContainer var1, Object var2) throws Exception;

        protected abstract void internalSet(ExtendedBlueprintContainer var1, Object var2, Object var3) throws Exception;

        public Object get(final Object instance, final ExtendedBlueprintContainer container) throws Exception {
            if (container.getAccessControlContext() == null) {
                return this.internalGet(container, instance);
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return PropertyDescriptor.this.internalGet(container, instance);
                    }
                }, container.getAccessControlContext());
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }

        public void set(final Object instance, final Object value, final ExtendedBlueprintContainer container) throws Exception {
            if (container.getAccessControlContext() == null) {
                this.internalSet(container, instance, value);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            PropertyDescriptor.this.internalSet(container, instance, value);
                            return null;
                        }
                    }, container.getAccessControlContext());
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        }

        protected Object convert(Object obj, Type type) throws Exception {
            return ExecutionContext.Holder.getContext().convert(obj, new GenericType(type));
        }
    }
}

