/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.timers.impl;

import java.util.Date;
import java.util.TimerTask;
import org.apache.servicemix.timers.Timer;
import org.apache.servicemix.timers.TimerListener;
import org.apache.servicemix.timers.TimerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerManagerImpl
implements TimerManager {
    private static final Logger LOG = LoggerFactory.getLogger(TimerManagerImpl.class);
    private java.util.Timer timer;

    public synchronized Timer schedule(TimerListener listener, long delay) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Schedule timer " + listener + " for " + delay);
        }
        TimerImpl tt = new TimerImpl(listener);
        if (this.timer == null) {
            this.timer = new java.util.Timer();
        }
        this.timer.schedule((TimerTask)tt, delay);
        return tt;
    }

    public synchronized Timer schedule(TimerListener listener, Date date) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Schedule timer " + listener + " at " + date);
        }
        TimerImpl tt = new TimerImpl(listener);
        if (this.timer == null) {
            this.timer = new java.util.Timer();
        }
        this.timer.schedule((TimerTask)tt, date);
        return tt;
    }

    public void start() {
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected static class TimerImpl
    extends TimerTask
    implements Timer {
        private TimerListener timerListener;

        public TimerImpl(TimerListener timerListener) {
            this.timerListener = timerListener;
        }

        public boolean cancel() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timer " + this.timerListener + " cancelled");
            }
            return super.cancel();
        }

        public TimerListener getTimerListener() {
            return this.timerListener;
        }

        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timer " + this.timerListener + " expired");
            }
            this.timerListener.timerExpired(this);
        }
    }
}

