/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidImpl;

public class XidFactoryImpl
implements XidFactory {
    private final byte[] baseId = new byte[64];
    private final long start;
    private long count = this.start = System.currentTimeMillis();

    public XidFactoryImpl(byte[] tmId) {
        System.arraycopy(tmId, 0, this.baseId, 8, tmId.length);
    }

    public XidFactoryImpl() {
        byte[] hostid;
        try {
            hostid = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            hostid = new byte[]{127, 0, 0, 1};
        }
        int uid = System.identityHashCode(this);
        this.baseId[8] = (byte)uid;
        this.baseId[9] = (byte)(uid >>> 8);
        this.baseId[10] = (byte)(uid >>> 16);
        this.baseId[11] = (byte)(uid >>> 24);
        byte[] entropy = new byte[2];
        new Random().nextBytes(entropy);
        this.baseId[12] = entropy[0];
        this.baseId[13] = entropy[1];
        System.arraycopy(hostid, 0, this.baseId, 14, hostid.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid createXid() {
        long id;
        byte[] globalId = (byte[])this.baseId.clone();
        XidFactoryImpl xidFactoryImpl = this;
        synchronized (xidFactoryImpl) {
            id = this.count++;
        }
        XidFactoryImpl.insertLong(id, globalId, 0);
        return new XidImpl(globalId);
    }

    public Xid createBranch(Xid globalId, int branch) {
        byte[] branchId = (byte[])this.baseId.clone();
        branchId[0] = (byte)branch;
        branchId[1] = (byte)(branch >>> 8);
        branchId[2] = (byte)(branch >>> 16);
        branchId[3] = (byte)(branch >>> 24);
        XidFactoryImpl.insertLong(this.start, branchId, 4);
        return new XidImpl(globalId, branchId);
    }

    public boolean matchesGlobalId(byte[] globalTransactionId) {
        if (globalTransactionId.length != 64) {
            return false;
        }
        for (int i = 8; i < globalTransactionId.length; ++i) {
            if (globalTransactionId[i] == this.baseId[i]) continue;
            return false;
        }
        long id = XidFactoryImpl.extractLong(globalTransactionId, 0);
        return id < this.start;
    }

    public boolean matchesBranchId(byte[] branchQualifier) {
        if (branchQualifier.length != 64) {
            return false;
        }
        long id = XidFactoryImpl.extractLong(branchQualifier, 4);
        if (id >= this.start) {
            return false;
        }
        for (int i = 12; i < branchQualifier.length; ++i) {
            if (branchQualifier[i] == this.baseId[i]) continue;
            return false;
        }
        return true;
    }

    public Xid recover(int formatId, byte[] globalTransactionid, byte[] branchQualifier) {
        return new XidImpl(formatId, globalTransactionid, branchQualifier);
    }

    static void insertLong(long value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)value;
        bytes[offset + 1] = (byte)(value >>> 8);
        bytes[offset + 2] = (byte)(value >>> 16);
        bytes[offset + 3] = (byte)(value >>> 24);
        bytes[offset + 4] = (byte)(value >>> 32);
        bytes[offset + 5] = (byte)(value >>> 40);
        bytes[offset + 6] = (byte)(value >>> 48);
        bytes[offset + 7] = (byte)(value >>> 56);
    }

    static long extractLong(byte[] bytes, int offset) {
        return (long)((bytes[offset + 0] & 0xFF) + ((bytes[offset + 1] & 0xFF) << 8) + ((bytes[offset + 2] & 0xFF) << 16)) + (((long)bytes[offset + 3] & 0xFFL) << 24) + (((long)bytes[offset + 4] & 0xFFL) << 32) + (((long)bytes[offset + 5] & 0xFFL) << 40) + (((long)bytes[offset + 6] & 0xFFL) << 48) + ((long)bytes[offset + 7] << 56);
    }
}

