/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.felix.framework.resolver.Content;

public final class BundleInputStream
extends InputStream {
    private final Content m_root;
    private final Enumeration m_content;
    private final OutputStreamBuffer m_outputBuffer = new OutputStreamBuffer();
    private ByteArrayInputStream m_buffer = null;
    private JarOutputStream m_output = null;
    private static final String DUMMY_ENTRY = "__DUMMY-ENTRY__/";

    public BundleInputStream(Content root) throws IOException {
        this.m_root = root;
        ArrayList<String> entries = new ArrayList<String>();
        int count = 0;
        boolean inMetaInf = true;
        String manifest = null;
        Enumeration e = this.m_root.getEntries();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            if (entry.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                if (manifest != null) continue;
                manifest = entry;
                continue;
            }
            if (entry.toUpperCase().startsWith("META-INF/") && entry.indexOf(47, "META-INF/".length()) < 0) {
                entries.add(count++, entry);
                continue;
            }
            entries.add(entry);
        }
        entries.add(count++, DUMMY_ENTRY);
        if (manifest == null) {
            manifest = "META-INF/MANIFEST.MF";
        }
        this.m_content = Collections.enumeration(entries);
        try {
            this.m_output = new JarOutputStream(this.m_outputBuffer);
            this.readNext(manifest);
            this.m_buffer = new ByteArrayInputStream(this.m_outputBuffer.m_outBuffer.toByteArray());
            this.m_outputBuffer.m_outBuffer = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public int read() throws IOException {
        if (this.m_output == null && this.m_buffer == null) {
            return -1;
        }
        if (this.m_buffer != null) {
            int result = this.m_buffer.read();
            if (result == -1) {
                this.m_buffer = null;
                return this.read();
            }
            return result;
        }
        if (this.m_content.hasMoreElements()) {
            String current = (String)this.m_content.nextElement();
            this.readNext(current);
            if (!this.m_content.hasMoreElements()) {
                this.m_output.close();
                this.m_output = null;
            }
            this.m_buffer = new ByteArrayInputStream(this.m_outputBuffer.m_outBuffer.toByteArray());
            this.m_outputBuffer.m_outBuffer = null;
        } else {
            this.m_output.close();
            this.m_output = null;
        }
        return this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNext(String path) throws IOException {
        this.m_outputBuffer.m_outBuffer = new ByteArrayOutputStream();
        if (path == DUMMY_ENTRY) {
            JarEntry entry = new JarEntry(path);
            this.m_output.putNextEntry(entry);
        } else {
            InputStream in = null;
            try {
                in = this.m_root.getEntryAsStream(path);
                if (in == null) {
                    throw new IOException("Missing entry");
                }
                JarEntry entry = new JarEntry(path);
                this.m_output.putNextEntry(entry);
                byte[] buffer = new byte[4096];
                int c = in.read(buffer);
                while (c != -1) {
                    this.m_output.write(buffer, 0, c);
                    c = in.read(buffer);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.m_output.closeEntry();
        this.m_output.flush();
    }

    private static final class OutputStreamBuffer
    extends OutputStream {
        ByteArrayOutputStream m_outBuffer = null;

        private OutputStreamBuffer() {
        }

        public void write(int b) {
            this.m_outBuffer.write(b);
        }

        public void write(byte[] buffer) throws IOException {
            this.m_outBuffer.write(buffer);
        }

        public void write(byte[] buffer, int offset, int length) {
            this.m_outBuffer.write(buffer, offset, length);
        }
    }
}

