/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="dev", name="threads", description="Show threads in the JVM.")
public class Threads
extends OsgiCommandSupport {
    @Option(name="-d", aliases={"--dump"}, description="Display thread stack traces")
    private boolean dump;
    @Option(name="-f", aliases={"--flat"}, description="Do not display threads as a tree")
    private boolean flat;
    @Option(name="-e", aliases={"--empty-groups"}, description="Show empty groups")
    private boolean empty;

    protected Object doExecute() throws Exception {
        HashMap<Long, ThreadInfo> threadInfos = new HashMap<Long, ThreadInfo>();
        if (this.dump) {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] infos = threadMXBean.isObjectMonitorUsageSupported() && threadMXBean.isSynchronizerUsageSupported() ? threadMXBean.dumpAllThreads(true, true) : threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE);
            for (ThreadInfo info : infos) {
                threadInfos.put(info.getThreadId(), info);
            }
            this.flat = true;
        }
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        new ThreadGroupData(group, threadInfos).print("");
        return null;
    }

    public class ThreadData {
        private final Thread thread;
        private ThreadInfo info;

        public ThreadData(Thread thread, ThreadInfo info) {
            this.thread = thread;
            this.info = info;
        }

        public void print(String indent) {
            if (Threads.this.dump && this.info != null) {
                this.printThreadInfo("    ");
            } else {
                System.out.println(indent + (Threads.this.flat ? "" : "    ") + "\"" + this.thread.getName() + "\": " + (Object)((Object)this.thread.getState()));
            }
        }

        private void printThreadInfo(String indent) {
            this.printThread(indent);
            StackTraceElement[] stacktrace = this.info.getStackTrace();
            MonitorInfo[] monitors = this.info.getLockedMonitors();
            for (int i = 0; i < stacktrace.length; ++i) {
                StackTraceElement ste = stacktrace[i];
                System.out.println(indent + "at " + ste.toString());
                for (MonitorInfo mi : monitors) {
                    if (mi.getLockedStackDepth() != i) continue;
                    System.out.println(indent + "  - locked " + mi);
                }
            }
            System.out.println();
        }

        private void printThread(String indent) {
            StringBuilder sb = new StringBuilder("\"" + this.info.getThreadName() + "\"" + " Id=" + this.info.getThreadId() + " in " + (Object)((Object)this.info.getThreadState()));
            if (this.info.getLockName() != null) {
                sb.append(" on lock=" + this.info.getLockName());
            }
            if (this.info.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (this.info.isInNative()) {
                sb.append(" (running in native)");
            }
            System.out.println(sb.toString());
            if (this.info.getLockOwnerName() != null) {
                System.out.println(indent + " owned by " + this.info.getLockOwnerName() + " Id=" + this.info.getLockOwnerId());
            }
        }

        private void printMonitorInfo(String indent) {
            MonitorInfo[] monitors = this.info.getLockedMonitors();
            if (monitors != null && monitors.length > 0) {
                System.out.println(indent + "Locked monitors: count = " + monitors.length);
                for (MonitorInfo mi : monitors) {
                    System.out.println(indent + "  - " + mi + " locked at ");
                    System.out.println(indent + "      " + mi.getLockedStackDepth() + " " + mi.getLockedStackFrame());
                }
                System.out.println();
            }
        }

        private void printLockInfo(String indent) {
            LockInfo[] locks = this.info.getLockedSynchronizers();
            if (locks != null && locks.length > 0) {
                System.out.println(indent + "Locked synchronizers: count = " + locks.length);
                for (LockInfo li : locks) {
                    System.out.println(indent + "  - " + li);
                }
                System.out.println();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ThreadGroupData {
        private final ThreadGroup group;
        private final List<ThreadGroupData> groups;
        private final List<ThreadData> threads;

        public ThreadGroupData(ThreadGroup group, Map<Long, ThreadInfo> infos) {
            int nbThreads;
            int nbGroups;
            this.group = group;
            ThreadGroup[] childGroups = new ThreadGroup[32];
            while ((nbGroups = group.enumerate(childGroups, false)) == childGroups.length) {
                childGroups = new ThreadGroup[childGroups.length * 2];
            }
            this.groups = new ArrayList<ThreadGroupData>();
            for (ThreadGroup tg : childGroups) {
                if (tg == null) continue;
                this.groups.add(new ThreadGroupData(tg, infos));
            }
            Thread[] childThreads = new Thread[32];
            while ((nbThreads = group.enumerate(childThreads, false)) == childThreads.length) {
                childThreads = new Thread[childThreads.length * 2];
            }
            this.threads = new ArrayList<ThreadData>();
            for (Thread t : childThreads) {
                if (t == null) continue;
                this.threads.add(new ThreadData(t, infos.get(t.getId())));
            }
        }

        public void print(String indent) {
            if (Threads.this.empty || this.hasThreads()) {
                if (!Threads.this.flat && !Threads.this.dump) {
                    System.out.println(indent + "Thread Group \"" + this.group.getName() + "\"");
                }
                for (ThreadGroupData tgd : this.groups) {
                    tgd.print(indent + (Threads.this.flat || Threads.this.dump ? "" : "    "));
                }
                for (ThreadData td : this.threads) {
                    td.print(indent + (Threads.this.flat ? "" : "    "));
                }
            }
        }

        public boolean hasThreads() {
            if (!this.threads.isEmpty()) {
                return true;
            }
            for (ThreadGroupData tgd : this.groups) {
                if (!tgd.hasThreads()) continue;
                return true;
            }
            return false;
        }
    }
}

