/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.admin.management.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.TabularData;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.admin.AdminService;
import org.apache.karaf.admin.Instance;
import org.apache.karaf.admin.InstanceSettings;
import org.apache.karaf.admin.management.AdminServiceMBean;
import org.apache.karaf.admin.management.codec.JmxInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminServiceMBeanImpl
extends StandardMBean
implements AdminServiceMBean {
    private AdminService adminService;
    private ThreadIO threadIo;

    public AdminServiceMBeanImpl() throws NotCompliantMBeanException {
        super(AdminServiceMBean.class);
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    public void setAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    public ThreadIO getThreadIo() {
        return this.threadIo;
    }

    public void setThreadIo(ThreadIO threadIo) {
        this.threadIo = threadIo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createInstance(String name, int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts, String features, String featureURLs) throws Exception {
        if ("".equals(location)) {
            location = null;
        }
        if ("".equals(javaOpts)) {
            javaOpts = null;
        }
        InstanceSettings settings = new InstanceSettings(sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, this.parseStringList(featureURLs), this.parseStringList(features));
        try {
            Instance inst;
            if (this.threadIo != null) {
                this.threadIo.setStreams((InputStream)new ByteArrayInputStream(new byte[0]), new PrintStream(new ByteArrayOutputStream()), new PrintStream(new ByteArrayOutputStream()));
            }
            if ((inst = this.adminService.createInstance(name, settings)) != null) {
                int n = inst.getPid();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            if (this.threadIo != null) {
                this.threadIo.close();
            }
        }
    }

    @Override
    public void changeSshPort(String name, int port) throws Exception {
        this.getExistingInstance(name).changeSshPort(port);
    }

    @Override
    public void changeRmiRegistryPort(String name, int port) throws Exception {
        this.getExistingInstance(name).changeRmiRegistryPort(port);
    }

    @Override
    public void changeRmiServerPort(String name, int port) throws Exception {
        this.getExistingInstance(name).changeRmiServerPort(port);
    }

    @Override
    public void changeJavaOpts(String name, String javaOpts) throws Exception {
        this.getExistingInstance(name).changeJavaOpts(javaOpts);
    }

    @Override
    public void destroyInstance(String name) throws Exception {
        this.getExistingInstance(name).destroy();
    }

    @Override
    public void startInstance(String name, String opts) throws Exception {
        this.getExistingInstance(name).start(opts);
    }

    @Override
    public void stopInstance(String name) throws Exception {
        this.getExistingInstance(name).stop();
    }

    @Override
    public void renameInstance(String originalName, String newName) throws Exception {
        this.adminService.renameInstance(originalName, newName);
    }

    @Override
    public TabularData getInstances() throws Exception {
        List<Instance> allInstances = Arrays.asList(this.adminService.getInstances());
        ArrayList<JmxInstance> instances = new ArrayList<JmxInstance>();
        for (Instance instance : allInstances) {
            instances.add(new JmxInstance(instance));
        }
        TabularData table = JmxInstance.tableFrom(instances);
        return table;
    }

    private Instance getExistingInstance(String name) {
        Instance i = this.adminService.getInstance(name);
        if (i == null) {
            throw new IllegalArgumentException("Instance '" + name + "' does not exist");
        }
        return i;
    }

    private List<String> parseStringList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            for (String el : value.split(",")) {
                String trimmed = el.trim();
                if (trimmed.length() == 0) continue;
                list.add(trimmed);
            }
        }
        return list;
    }
}

