/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.AsyncBaseLifeCycle;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.Registry;
import org.apache.servicemix.common.ResolvedEndpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.SyncLifeCycleWrapper;
import org.apache.servicemix.common.xbean.BaseXBeanDeployer;
import org.apache.servicemix.common.xbean.XBeanServiceUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class DefaultComponent
extends AsyncBaseLifeCycle
implements ServiceMixComponent {
    protected final transient Logger logger = LoggerFactory.getLogger(DefaultComponent.class);
    protected Registry registry;
    protected BaseServiceUnitManager serviceUnitManager;
    protected ServiceUnit serviceUnit;
    protected ComponentLifeCycle lifeCycle;

    public DefaultComponent() {
        this.setComponent(this);
        this.logger.debug("Create the registry");
        this.registry = this.createRegistry();
        this.logger.debug("Create the SU manager");
        this.serviceUnitManager = this.createServiceUnitManager();
        this.logger.debug("Create the XBean SU");
        XBeanServiceUnit su = new XBeanServiceUnit();
        su.setName("#default#");
        su.setComponent(this);
        this.serviceUnit = su;
        this.registry.registerServiceUnit(this.serviceUnit);
    }

    public ComponentLifeCycle getLifeCycle() {
        if (this.lifeCycle == null) {
            try {
                this.lifeCycle = new SyncLifeCycleWrapper(this);
            }
            catch (Throwable t) {
                this.lifeCycle = this;
            }
        }
        return this.lifeCycle;
    }

    public ServiceUnitManager getServiceUnitManager() {
        return this.serviceUnitManager;
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        this.logger.debug("Querying service description for {}", (Object)endpoint);
        String key = EndpointSupport.getKey(endpoint);
        Endpoint ep = this.registry.getEndpoint(key);
        if (ep != null) {
            Document doc = ep.getDescription();
            if (doc == null) {
                this.logger.debug("No description found for {}", (Object)key);
            }
            return doc;
        }
        this.logger.debug("No endpoint found for {}", (Object)key);
        return null;
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        String key = EndpointSupport.getKey(endpoint);
        Endpoint ep = this.registry.getEndpoint(key);
        if (ep != null) {
            if (ep.getRole() != MessageExchange.Role.PROVIDER) {
                this.logger.debug("Endpoint {} is a consumer. Refusing exchange with consumer.", (Object)key);
                return false;
            }
            return ep.isExchangeOkay(exchange);
        }
        this.logger.debug("No endpoint found for {}. Refusing exchange with consumer.", (Object)key);
        return false;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public QName getEPRServiceName() {
        return new QName(this.getEPRUri(), this.getEPRComponentName());
    }

    public QName getEPRElementName() {
        return new QName(this.getEPRUri(), "epr");
    }

    protected String[] getEPRProtocols() {
        String protocol = this.getEPRStrippedComponentName().toLowerCase() + ":";
        return new String[]{protocol};
    }

    private String getEPRComponentName() {
        String suffix = this.getClass().getName();
        if ((suffix = suffix.substring(suffix.lastIndexOf(46) + 1)).lastIndexOf(36) > 0) {
            suffix = suffix.substring(suffix.lastIndexOf(36) + 1);
        }
        return suffix;
    }

    private String getEPRStrippedComponentName() {
        String suffix = this.getEPRComponentName();
        if (suffix.endsWith("Component")) {
            suffix = suffix.substring(0, suffix.length() - 9);
        }
        return suffix;
    }

    private String getEPRUri() {
        String uri = "urn:servicemix:" + this.getEPRStrippedComponentName().toLowerCase();
        return uri;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        String[] protocols = this.getEPRProtocols();
        QName elementName = this.getEPRElementName();
        QName serviceName = this.getEPRServiceName();
        for (int i = 0; i < protocols.length; ++i) {
            ServiceEndpoint ep = ResolvedEndpoint.resolveEndpoint(epr, elementName, serviceName, protocols[i]);
            if (ep == null) continue;
            return ep;
        }
        return null;
    }

    protected BaseServiceUnitManager createServiceUnitManager() {
        Class[] classes = this.getEndpointClasses();
        if (classes == null) {
            return null;
        }
        Deployer[] deployers = new Deployer[]{new BaseXBeanDeployer((ServiceMixComponent)this, classes)};
        return new BaseServiceUnitManager(this, deployers);
    }

    protected Registry createRegistry() {
        return new Registry(this);
    }

    public ComponentContext getComponentContext() {
        return this.getContext();
    }

    public String getComponentName() {
        if (this.getComponentContext() == null) {
            return "Component (" + this.getClass().getName() + ") not yet initialized";
        }
        return this.getComponentContext().getComponentName();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public ServiceUnit getServiceUnit() {
        return this.serviceUnit;
    }

    protected List getConfiguredEndpoints() {
        return null;
    }

    protected Class[] getEndpointClasses() {
        return null;
    }

    protected static List asList(Object[] endpoints) {
        if (endpoints == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(endpoints);
    }

    public synchronized void addEndpoint(Endpoint endpoint) throws Exception {
        endpoint.setServiceUnit(this.serviceUnit);
        this.validateEndpoint(endpoint);
        endpoint.validate();
        this.registry.registerEndpoint(endpoint);
        this.serviceUnit.addEndpoint(endpoint);
    }

    public synchronized void removeEndpoint(Endpoint endpoint) throws Exception {
        this.registry.unregisterEndpoint(endpoint);
        endpoint.getServiceUnit().removeEndpoint(endpoint);
    }

    public boolean isKnownEndpoint(Endpoint endpoint) {
        Class[] endpointClasses = this.getEndpointClasses();
        if (endpointClasses != null) {
            for (int i = 0; i < endpointClasses.length; ++i) {
                Class endpointClass = endpointClasses[i];
                if (!endpointClass.isInstance(endpoint)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void validateEndpoint(Endpoint endpoint) throws DeploymentException {
        if (!this.isKnownEndpoint(endpoint)) {
            throw new DeploymentException("The endpoint: " + endpoint + " is not an instance of any of the allowable types: " + Arrays.asList(this.getEndpointClasses()));
        }
    }

    protected void doInit() throws Exception {
        super.doInit();
        List endpoints = this.getConfiguredEndpoints();
        if (endpoints != null && !endpoints.isEmpty()) {
            for (Endpoint endpoint : endpoints) {
                if (endpoint == null) {
                    this.logger.warn("Ignoring null endpoint in list: {}", (Object)endpoints);
                    continue;
                }
                this.addEndpoint(endpoint);
            }
        }
        this.serviceUnit.init();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.serviceUnit.start();
    }

    protected void doStop() throws Exception {
        this.serviceUnit.stop();
        super.doStop();
    }

    protected void doShutDown() throws Exception {
        this.serviceUnit.shutDown();
        super.doShutDown();
    }
}

