/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.gogo.runtime.CommandNotFoundException;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.ssh.KarafJaasPasswordAuthenticator;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellCommandFactory
implements CommandFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellCommandFactory.class);
    private CommandProcessor commandProcessor;

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public Command createCommand(String command) {
        return new ShellCommand(command);
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public class ShellCommand
    implements Command,
    SessionAware {
        private String command;
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;

        public ShellCommand(String command) {
            this.command = command;
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void start(Environment env) throws IOException {
            try {
                final CommandSession session = ShellCommandFactory.this.commandProcessor.createSession(this.in, new PrintStream(this.out), new PrintStream(this.err));
                session.put("SCOPE", (Object)"shell:osgi:*");
                session.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
                for (Map.Entry e : env.getEnv().entrySet()) {
                    session.put((String)e.getKey(), e.getValue());
                }
                try {
                    Object result;
                    Subject subject;
                    Subject subject2 = subject = this.session != null ? (Subject)this.session.getAttribute(KarafJaasPasswordAuthenticator.SUBJECT_ATTRIBUTE_KEY) : null;
                    if (subject != null) {
                        try {
                            result = Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    return session.execute((CharSequence)ShellCommand.this.command);
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            throw e.getException();
                        }
                    } else {
                        result = session.execute((CharSequence)this.command);
                    }
                    if (result != null) {
                        session.getConsole().println(session.format(result, 0));
                    }
                }
                catch (Throwable t) {
                    try {
                        if (t instanceof CommandNotFoundException) {
                            LOGGER.debug("Unknown command entered", t);
                        } else {
                            LOGGER.info("Exception caught while executing command", t);
                        }
                        session.put("karaf.lastException", (Object)t);
                        if (t instanceof CommandException) {
                            session.getConsole().println(((CommandException)t).getNiceHelp());
                        } else if (t instanceof CommandNotFoundException) {
                            String str = Ansi.ansi().fg(Ansi.Color.RED).a("Command not found: ").a(Ansi.Attribute.INTENSITY_BOLD).a(((CommandNotFoundException)t).getCommand()).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).toString();
                            session.getConsole().println(str);
                        }
                        if (this.getBoolean(session, "karaf.printStackTraces")) {
                            session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                            t.printStackTrace(session.getConsole());
                            session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                        } else if (!(t instanceof CommandException) && !(t instanceof CommandNotFoundException)) {
                            session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                            session.getConsole().println("Error executing command: " + (t.getMessage() != null ? t.getMessage() : t.getClass().getName()));
                            session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                        }
                        session.getConsole().flush();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw (IOException)new IOException("Unable to start shell").initCause(e);
                }
                catch (Throwable throwable) {
                    ShellCommandFactory.close(new Closeable[]{this.in, this.out, this.err});
                    this.callback.onExit(0);
                    throw throwable;
                }
            }
            ShellCommandFactory.close(new Closeable[]{this.in, this.out, this.err});
            this.callback.onExit(0);
        }

        public void destroy() {
        }

        protected boolean getBoolean(CommandSession session, String name) {
            Object s = session.get(name);
            if (s == null) {
                s = System.getProperty(name);
            }
            if (s == null) {
                return false;
            }
            if (s instanceof Boolean) {
                return (Boolean)s;
            }
            return Boolean.parseBoolean(s.toString());
        }
    }
}

