/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.util.Properties;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigCommandSupport
extends OsgiCommandSupport {
    public static final String PROPERTY_CONFIG_PID = "ConfigCommand.PID";
    public static final String PROPERTY_CONFIG_PROPS = "ConfigCommand.Props";
    private static final String PID_FILTER = "(service.pid=%s*)";
    private static final String FILE_PREFIX = "file:";
    private static final String CONFIG_SUFFIX = ".cfg";
    private static final String FACTORY_SEPARATOR = "-";
    private static final String FILEINSTALL_FILE_NAME = "felix.fileinstall.filename";
    protected File storage;
    private List<ArtifactInstaller> artifactInstallers;

    protected Object doExecute() throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        if (ref == null) {
            System.out.println("ConfigurationAdmin service is unavailable.");
            return null;
        }
        ConfigurationAdmin admin = this.getConfigurationAdmin();
        if (admin == null) {
            System.out.println("ConfigAdmin service is unavailable.");
            return null;
        }
        this.doExecute(admin);
        return null;
    }

    protected Dictionary getEditedProps() throws Exception {
        return (Dictionary)this.session.get(PROPERTY_CONFIG_PROPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigurationAdmin getConfigurationAdmin() {
        ServiceReference ref = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        if (ref == null) {
            return null;
        }
        try {
            ConfigurationAdmin admin = (ConfigurationAdmin)this.getBundleContext().getService(ref);
            if (admin == null) {
                ConfigurationAdmin configurationAdmin = null;
                return configurationAdmin;
            }
            ConfigurationAdmin configurationAdmin = admin;
            return configurationAdmin;
        }
        finally {
            this.getBundleContext().ungetService(ref);
        }
    }

    protected abstract void doExecute(ConfigurationAdmin var1) throws Exception;

    public Configuration findConfigurationByFileName(ConfigurationAdmin admin, String fileName) throws IOException, InvalidSyntaxException {
        if (fileName != null && fileName.contains(FACTORY_SEPARATOR)) {
            String factoryPid = fileName.substring(0, fileName.lastIndexOf(FACTORY_SEPARATOR));
            String absoluteFileName = FILE_PREFIX + this.storage.getAbsolutePath() + File.separator + fileName + CONFIG_SUFFIX;
            Configuration[] configurations = admin.listConfigurations(String.format(PID_FILTER, factoryPid));
            if (configurations != null) {
                for (Configuration configuration : configurations) {
                    String fileInstallFileName;
                    Dictionary dictionary = configuration.getProperties();
                    if (dictionary == null || !absoluteFileName.equals(fileInstallFileName = (String)dictionary.get(FILEINSTALL_FILE_NAME))) continue;
                    return configuration;
                }
            }
        }
        return null;
    }

    protected void update(ConfigurationAdmin admin, String pid, Dictionary props, boolean bypassStorage) throws IOException {
        if (!bypassStorage && this.storage != null) {
            this.persistConfiguration(admin, pid, props);
        } else {
            this.updateConfiguration(admin, pid, props);
        }
    }

    protected void persistConfiguration(ConfigurationAdmin admin, String pid, Dictionary props) throws IOException {
        Object val;
        File storageFile = new File(this.storage, pid + CONFIG_SUFFIX);
        Configuration cfg = admin.getConfiguration(pid, null);
        if (cfg != null && cfg.getProperties() != null && (val = cfg.getProperties().get(FILEINSTALL_FILE_NAME)) instanceof String) {
            if (((String)val).startsWith(FILE_PREFIX)) {
                val = ((String)val).substring(FILE_PREFIX.length());
            }
            storageFile = new File((String)val);
        }
        Properties p = new Properties(storageFile);
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if ("service.pid".equals(key) || "service.factoryPid".equals(key) || FILEINSTALL_FILE_NAME.equals(key)) continue;
            p.put((String)key, (String)props.get(key));
        }
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        for (String key : p.keySet()) {
            if (props.get(key) != null || "service.pid".equals(key) || "service.factoryPid".equals(key) || FILEINSTALL_FILE_NAME.equals(key)) continue;
            propertiesToRemove.add(key.toString());
        }
        for (String key : propertiesToRemove) {
            p.remove(key);
        }
        this.storage.mkdirs();
        p.save();
        this.updateFileInstall(storageFile);
    }

    private void updateFileInstall(File storageFile) {
        if (this.artifactInstallers != null) {
            for (ArtifactInstaller installer : this.artifactInstallers) {
                if (!installer.canHandle(storageFile)) continue;
                try {
                    installer.update(storageFile);
                }
                catch (Exception e) {
                    this.log.warn("Error updating config " + storageFile + " in felix fileinstall" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void updateConfiguration(ConfigurationAdmin admin, String pid, Dictionary props) throws IOException {
        String[] pids;
        Configuration cfg = admin.getConfiguration(pid, null);
        if (cfg.getProperties() == null && (pids = this.parsePid(pid))[1] != null) {
            cfg = admin.createFactoryConfiguration(pids[0], null);
        }
        if (cfg.getBundleLocation() != null) {
            cfg.setBundleLocation(null);
        }
        cfg.update(props);
    }

    protected String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    protected void deleteStorage(String pid) throws Exception {
        File cfgFile = new File(this.storage, pid + CONFIG_SUFFIX);
        cfgFile.delete();
    }

    public File getStorage() {
        return this.storage;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }

    public void setArtifactInstallers(List<ArtifactInstaller> artifactInstallers) {
        this.artifactInstallers = artifactInstallers;
    }
}

