/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.obr.internal;

import java.util.ArrayList;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.karaf.management.mbeans.obr.ObrMBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObrMBeanImpl
extends StandardMBean
implements ObrMBean {
    private static final char VERSION_DELIM = ',';
    private BundleContext bundleContext;
    private RepositoryAdmin repositoryAdmin;

    public ObrMBeanImpl() throws NotCompliantMBeanException {
        super(ObrMBean.class);
    }

    @Override
    public List<String> listUrls() throws Exception {
        Repository[] repositories = this.repositoryAdmin.listRepositories();
        ArrayList<String> urls = new ArrayList<String>();
        for (int i = 0; i < repositories.length; ++i) {
            urls.add(repositories[i].getURI());
        }
        return urls;
    }

    @Override
    public void addUrl(String url) throws Exception {
        this.repositoryAdmin.addRepository(url);
    }

    @Override
    public void removeUrl(String url) throws Exception {
        this.repositoryAdmin.removeRepository(url);
    }

    @Override
    public void refreshUrl(String url) throws Exception {
        this.repositoryAdmin.addRepository(url);
    }

    @Override
    public TabularData list() throws Exception {
        CompositeType bundleType = new CompositeType("OBR Resource", "Bundle available in the OBR", new String[]{"presentationname", "symbolicname", "version"}, new String[]{"Presentation Name", "Symbolic Name", "Version"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
        TabularType tableType = new TabularType("OBR Resources", "Table of all resources/bundles available in the OBR", bundleType, new String[]{"presentationname"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        Resource[] resources = this.repositoryAdmin.discoverResources("(|(presentationname=*)(symbolicname=*))");
        for (int i = 0; i < resources.length; ++i) {
            CompositeDataSupport data = new CompositeDataSupport(bundleType, new String[]{"presentationname", "symbolicname", "version"}, new Object[]{resources[i].getPresentationName(), resources[i].getSymbolicName(), resources[i].getVersion()});
            table.put(data);
        }
        return table;
    }

    @Override
    public void deploy(String bundle) throws Exception {
        this.deploy(bundle, false);
    }

    @Override
    public void deploy(String bundle, boolean start) throws Exception {
        Resolver resolver = this.repositoryAdmin.resolver();
        String[] target = this.getTarget(bundle);
        Resource resource = this.selectNewestVersion(this.searchRepository(this.repositoryAdmin, target[0], target[1]));
        if (resource == null) {
            throw new IllegalArgumentException("Unknown bundle " + target[0]);
        }
        resolver.add(resource);
        if (resolver.getAddedResources() == null || resolver.getAddedResources().length > 0) {
            // empty if block
        }
        if (resolver.resolve()) {
            Resource[] resources = resolver.getAddedResources();
            resources = resolver.getRequiredResources();
            resources = resolver.getOptionalResources();
            try {
                resolver.deploy(start ? 16 : 0);
            }
            catch (IllegalStateException ex) {
                throw new IllegalStateException("Can't deploy using OBR", ex);
            }
        }
    }

    private Resource[] searchRepository(RepositoryAdmin admin, String targetId, String targetVersion) throws InvalidSyntaxException {
        try {
            Bundle bundle = this.getBundleContext().getBundle(Long.parseLong(targetId));
            targetId = bundle.getSymbolicName();
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer("(|(presentationname=");
        sb.append(targetId);
        sb.append(")(symbolicname=");
        sb.append(targetId);
        sb.append("))");
        if (targetVersion != null) {
            sb.insert(0, "(&");
            sb.append("(version=");
            sb.append(targetVersion);
            sb.append("))");
        }
        return admin.discoverResources(sb.toString());
    }

    private Resource selectNewestVersion(Resource[] resources) {
        int idx = -1;
        Version v = null;
        for (int i = 0; resources != null && i < resources.length; ++i) {
            if (i == 0) {
                idx = 0;
                v = resources[i].getVersion();
                continue;
            }
            Version vtmp = resources[i].getVersion();
            if (vtmp.compareTo((Object)v) <= 0) continue;
            idx = i;
            v = vtmp;
        }
        return idx < 0 ? null : resources[idx];
    }

    private String[] getTarget(String bundle) {
        int idx = bundle.indexOf(44);
        String[] target = idx > 0 ? new String[]{bundle.substring(0, idx), bundle.substring(idx + 1)} : new String[]{bundle, null};
        return target;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public RepositoryAdmin getRepositoryAdmin() {
        return this.repositoryAdmin;
    }

    public void setRepositoryAdmin(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }
}

