/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.tools.wsdl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.servicemix.common.tools.wsdl.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaCollection {
    private final Logger logger = LoggerFactory.getLogger(SchemaCollection.class);
    private Map<String, Schema> schemas;
    private URI baseUri;

    public SchemaCollection() {
        this(null);
    }

    public SchemaCollection(URI baseUri) {
        this.logger.debug("Initializing schema collection with baseUri: {}", (Object)baseUri);
        this.baseUri = baseUri;
        this.schemas = new HashMap<String, Schema>();
    }

    public Schema getSchema(String namespaceURI) {
        return this.schemas.get(namespaceURI);
    }

    public void read(Element elem, URI sourceUri) throws Exception {
        String namespace = elem.getAttribute("targetNamespace");
        Schema schema = this.schemas.get(namespace);
        if (schema == null) {
            schema = new Schema();
            schema.addSourceUri(sourceUri);
            schema.setRoot(elem);
            schema.setNamespace(elem.getAttribute("targetNamespace"));
            this.schemas.put(schema.getNamespace(), schema);
        } else if (!schema.getSourceUris().contains(sourceUri)) {
            NodeList nodes = elem.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                schema.getRoot().appendChild(schema.getRoot().getOwnerDocument().importNode(nodes.item(i), true));
            }
            schema.addSourceUri(sourceUri);
        }
        this.handleImports(schema, sourceUri);
    }

    public void read(String location, URI baseUri) throws Exception {
        URI loc;
        this.logger.debug("Reading schema at '{}' with baseUri '{}'", (Object)location, (Object)baseUri);
        if (baseUri == null) {
            baseUri = this.baseUri;
        }
        if (baseUri != null) {
            loc = SchemaCollection.resolve(baseUri, location);
            if (!loc.isAbsolute()) {
                throw new IllegalArgumentException("Unable to resolve '" + loc.toString() + "' relative to '" + baseUri + "'");
            }
        } else {
            loc = new URI(location);
            if (!loc.isAbsolute()) {
                throw new IllegalArgumentException("Location '" + loc.toString() + "' is not absolute and no baseUri specified");
            }
        }
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(loc.toURL().openStream());
        inputSource.setSystemId(loc.toString());
        this.read(inputSource);
    }

    public void read(InputSource inputSource) throws Exception {
        DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
        docFac.setNamespaceAware(true);
        DocumentBuilder builder = docFac.newDocumentBuilder();
        Document doc = builder.parse(inputSource);
        this.read(doc.getDocumentElement(), inputSource.getSystemId() != null ? new URI(inputSource.getSystemId()) : null);
    }

    protected void handleImports(Schema schema, URI baseUri) throws Exception {
        NodeList children = schema.getRoot().getChildNodes();
        ArrayList<Element> imports = new ArrayList<Element>();
        ArrayList<Element> includes = new ArrayList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element ce = (Element)child;
            if ("http://www.w3.org/2001/XMLSchema".equals(ce.getNamespaceURI()) && "import".equals(ce.getLocalName())) {
                imports.add(ce);
                continue;
            }
            if (!"http://www.w3.org/2001/XMLSchema".equals(ce.getNamespaceURI()) || !"include".equals(ce.getLocalName())) continue;
            includes.add(ce);
        }
        for (Element ce : imports) {
            String namespace = ce.getAttribute("namespace");
            String location = ce.getAttribute("schemaLocation");
            schema.addImport(namespace);
            schema.getRoot().removeChild(ce);
            if (location == null || "".equals(location)) continue;
            this.read(location, baseUri);
        }
        for (Element ce : includes) {
            String location = ce.getAttribute("schemaLocation");
            Node parentNode = ce.getParentNode();
            Element root = schema.getRoot();
            if (root == parentNode) {
                this.logger.debug("Removing child include node: {}", (Object)ce);
                schema.getRoot().removeChild(ce);
            } else {
                this.logger.warn("Skipping child include node removal: {}", (Object)ce);
            }
            if (location == null || "".equals(location)) continue;
            this.read(location, baseUri);
        }
    }

    protected static URI resolve(URI base, String location) {
        if ("jar".equals(base.getScheme())) {
            String str = base.toString();
            String[] parts = str.split("!");
            parts[1] = URI.create(parts[1]).resolve(location).toString();
            return URI.create(parts[0] + "!" + parts[1]);
        }
        return base.resolve(location);
    }

    public int getSize() {
        if (this.schemas != null) {
            return this.schemas.size();
        }
        return 0;
    }

    public Collection<Schema> getSchemas() {
        if (this.schemas != null) {
            return this.schemas.values();
        }
        return Collections.emptySet();
    }
}

