/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="shell", name="command-watch", description="Watches & refreshes the output of a command")
public class WatchAction
extends AbstractAction {
    @Option(name="-n", aliases={"--interval"}, description="The interval between executions of the command in seconds", required=false, multiValued=false)
    private long interval = 1L;
    @Argument(index=0, name="command", description="The command to watch / refresh", required=true, multiValued=true)
    private String[] arguments;
    CommandProcessor commandProcessor;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        if (this.arguments == null || this.arguments.length == 0) {
            System.err.println("Argument expected");
            return null;
        }
        StringBuilder command = new StringBuilder();
        for (String arg : this.arguments) {
            command.append(arg).append(" ");
        }
        WatchTask watchTask = new WatchTask(this.commandProcessor, command.toString().trim());
        this.executorService.scheduleAtFixedRate(watchTask, 0L, this.interval, TimeUnit.SECONDS);
        try {
            this.session.getKeyboard().read();
            watchTask.abort();
        }
        finally {
            this.executorService.shutdownNow();
            watchTask.close();
            return null;
        }
    }

    public CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public class WatchTask
    implements Runnable {
        private final CommandProcessor processor;
        private final String command;
        CommandSession session;
        ByteArrayOutputStream byteArrayOutputStream = null;
        PrintStream printStream = null;
        boolean doDisplay = true;

        public WatchTask(CommandProcessor processor, String command) {
            this.processor = processor;
            this.command = command;
        }

        public void run() {
            try {
                this.byteArrayOutputStream = new ByteArrayOutputStream();
                this.printStream = new PrintStream(this.byteArrayOutputStream);
                this.session = WatchAction.this.commandProcessor.createSession(null, this.printStream, this.printStream);
                String output = "";
                this.session.execute((CharSequence)this.command);
                output = this.byteArrayOutputStream.toString();
                if (this.doDisplay) {
                    System.out.print("\u001b[2J");
                    System.out.print("\u001b[1;1H");
                    System.out.print(output);
                    System.out.flush();
                }
                this.byteArrayOutputStream.close();
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void abort() {
            this.doDisplay = false;
        }

        public void close() throws IOException {
            if (this.session != null) {
                this.session.close();
            }
            if (this.byteArrayOutputStream != null) {
                this.byteArrayOutputStream.close();
            }
            if (this.printStream != null) {
                this.printStream.close();
            }
        }
    }
}

