/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringMap
extends AbstractMap<String, Object> {
    private static final CharArrayComparator COMPARATOR = new CharArrayComparator();
    private final TreeMap<char[], KeyValueEntry> m_map = new TreeMap(COMPARATOR);

    public StringMap(boolean caseSensitive) {
    }

    public StringMap(Map map, boolean caseSensitive) {
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.m_map.containsKey(StringMap.toUpperCase(arg0.toString()));
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.m_map.containsValue(arg0);
    }

    @Override
    public Object get(Object arg0) {
        KeyValueEntry kve = this.m_map.get(StringMap.toUpperCase(arg0.toString()));
        return kve != null ? kve.value : null;
    }

    @Override
    public Object put(String key, Object value) {
        KeyValueEntry kve = this.m_map.put(StringMap.toUpperCase(key), new KeyValueEntry(key, value));
        return kve != null ? kve.value : null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (Map.Entry<? extends String, ? extends Object> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Object remove(Object arg0) {
        KeyValueEntry kve = this.m_map.remove(StringMap.toUpperCase(arg0.toString()));
        return kve != null ? kve.value : null;
    }

    @Override
    public void clear() {
        this.m_map.clear();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    Iterator<Map.Entry<char[], KeyValueEntry>> it;
                    {
                        this.it = StringMap.this.m_map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        return this.it.next().getValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return StringMap.this.m_map.size();
            }
        };
    }

    private static char[] toUpperCase(String str) {
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (c < '\u0080') {
                if ('a' > c || c > 'z') continue;
                ch[i] = (char)(c - 32);
                continue;
            }
            ch[i] = Character.toUpperCase(c);
        }
        return ch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyValueEntry
    implements Map.Entry<String, Object> {
        String key;
        Object value;

        private KeyValueEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            Object v = this.value;
            this.value = value;
            return v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharArrayComparator
    implements Comparator<char[]> {
        private CharArrayComparator() {
        }

        @Override
        public int compare(char[] v1, char[] v2) {
            int len1 = v1.length;
            int len2 = v2.length;
            int n = Math.min(len1, len2);
            for (int k = 0; k < n; ++k) {
                char c1 = v1[k];
                char c2 = v2[k];
                if (c1 == c2) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }
    }
}

