/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.memory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreListener;
import org.apache.servicemix.store.base.BaseStoreFactory;
import org.apache.servicemix.store.memory.MemoryStore;
import org.apache.servicemix.store.memory.TimeoutMemoryStore;

public class MemoryStoreFactory
extends BaseStoreFactory {
    private IdGenerator idGenerator = new IdGenerator();
    private Map<String, MemoryStore> stores = new HashMap<String, MemoryStore>();
    private long timeout = -1L;

    public synchronized Store open(String name) throws IOException {
        MemoryStore store = this.stores.get(name);
        if (store == null) {
            store = this.timeout <= 0L ? new MemoryStore(this.idGenerator) : new TimeoutMemoryStore(this.idGenerator, this.timeout);
            for (StoreListener listener : this.storeListeners) {
                store.addListener(listener);
            }
            this.stores.put(name, store);
        }
        return store;
    }

    public synchronized void close(Store store) throws IOException {
        this.stores.remove(store);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

