/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.verifier;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.security.util.BundleInputStream;
import org.apache.felix.framework.security.util.TrustManager;

public final class BundleDNParser {
    private static final Method m_getCodeSigners;
    private static final Method m_getSignerCertPath;
    private static final Method m_getCertificates;
    private final Logger m_logger;
    private final Map m_cache = new WeakHashMap();
    private final Map m_allCache = new WeakHashMap();
    private final TrustManager m_manager;

    public BundleDNParser(TrustManager manager, Logger logger) {
        this.m_manager = manager;
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCache() {
        Map map = this.m_cache;
        synchronized (map) {
            return new HashMap(this.m_cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String root, X509Certificate[] dnChains) {
        Map map = this.m_cache;
        synchronized (map) {
            this.m_cache.put(root, dnChains);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDNChains(BundleRevisionImpl root, Content content, int signersType) throws Exception {
        Map map;
        if (signersType == 2) {
            map = this.m_cache;
            synchronized (map) {
                if (this.m_cache.containsKey(root)) {
                    Map result = (Map)this.m_cache.get(root);
                    if (result != null && result.isEmpty()) {
                        throw new IOException("Bundle not properly signed");
                    }
                    return;
                }
            }
        }
        map = this.m_allCache;
        synchronized (map) {
            if (this.m_allCache.containsKey(root)) {
                Map result = (Map)this.m_allCache.get(root);
                if (result != null && result.isEmpty()) {
                    throw new IOException("Bundle not properly signed");
                }
                return;
            }
        }
        Map result = null;
        Exception org = null;
        try {
            result = this._getDNChains(content, signersType == 2);
        }
        catch (Exception ex) {
            org = ex;
        }
        if (signersType == 2) {
            Map map2 = this.m_cache;
            synchronized (map2) {
                this.m_cache.put(root, result);
            }
        }
        Map map3 = this.m_allCache;
        synchronized (map3) {
            this.m_allCache.put(root, result);
        }
        if (org != null) {
            throw org;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDNChains(BundleRevisionImpl root, Content bundleRevision, int signersType) {
        Map map;
        if (signersType == 2) {
            map = this.m_cache;
            synchronized (map) {
                if (this.m_cache.containsKey(root)) {
                    Map result = (Map)this.m_cache.get(root);
                    HashMap hashMap = result == null ? new HashMap() : new HashMap(result);
                    return hashMap;
                }
            }
        }
        map = this.m_allCache;
        synchronized (map) {
            if (this.m_allCache.containsKey(root)) {
                Map result = (Map)this.m_allCache.get(root);
                HashMap hashMap = result == null ? new HashMap() : new HashMap(result);
                return hashMap;
            }
        }
        Map result = null;
        try {
            result = this._getDNChains(bundleRevision, signersType == 2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (signersType == 2) {
            Map map2 = this.m_cache;
            synchronized (map2) {
                this.m_cache.put(root, result);
            }
        }
        Map map3 = this.m_allCache;
        synchronized (map3) {
            this.m_allCache.put(root, result);
        }
        return result == null ? new HashMap() : new HashMap(result);
    }

    private Map _getDNChains(Content content, boolean check) throws IOException {
        Certificate[] certificates = null;
        certificates = this.getCertificates(new BundleInputStream(content), check);
        if (certificates == null) {
            return null;
        }
        ArrayList rootChains = new ArrayList();
        this.getRootChains(certificates, rootChains, check);
        HashMap<X509Certificate, List> result = new HashMap<X509Certificate, List>();
        Iterator rootIter = rootChains.iterator();
        while (rootIter.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            List chain = (List)rootIter.next();
            Iterator iter = chain.iterator();
            X509Certificate current = (X509Certificate)iter.next();
            result.put(current, chain);
        }
        if (!result.isEmpty()) {
            return result;
        }
        throw new IOException();
    }

    private X509Certificate[] getCertificates(InputStream input, boolean check) throws IOException {
        JarInputStream bundle = new JarInputStream(input, true);
        if (bundle.getManifest() == null) {
            return null;
        }
        ArrayList certificateChains = new ArrayList();
        int count = certificateChains.size();
        JarEntry entry = bundle.getNextJarEntry();
        while (entry != null) {
            if (!(entry.isDirectory() || entry.getName().startsWith("META-INF/") && entry.getName().indexOf(47, "META-INF/".length()) < 0)) {
                byte[] tmp = new byte[4096];
                while (bundle.read(tmp, 0, tmp.length) != -1) {
                }
                Certificate[] certificates = entry.getCertificates();
                if (certificates == null && m_getCodeSigners != null) {
                    try {
                        Object[] signers = (Object[])m_getCodeSigners.invoke((Object)entry, null);
                        if (signers != null) {
                            ArrayList certChains = new ArrayList();
                            for (int i = 0; i < signers.length; ++i) {
                                Object path = m_getSignerCertPath.invoke(signers[i], null);
                                certChains.addAll((List)m_getCertificates.invoke(path, null));
                            }
                            certificates = certChains.toArray(new Certificate[certChains.size()]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (certificates == null || certificates.length == 0) {
                    return null;
                }
                ArrayList chains = new ArrayList();
                this.getRootChains(certificates, chains, check);
                if (certificateChains.isEmpty()) {
                    certificateChains.addAll(chains);
                    count = certificateChains.size();
                } else {
                    Iterator iter2 = certificateChains.iterator();
                    while (iter2.hasNext()) {
                        X509Certificate cert = (X509Certificate)((List)iter2.next()).get(0);
                        boolean found = false;
                        Iterator iter3 = chains.iterator();
                        while (iter3.hasNext()) {
                            X509Certificate cert2 = (X509Certificate)((List)iter3.next()).get(0);
                            if (!((Object)cert.getSubjectDN()).equals(cert2.getSubjectDN()) || !cert.equals(cert2)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        iter2.remove();
                    }
                }
                if (certificateChains.isEmpty()) {
                    if (count > 0) {
                        throw new IOException("Bad signers");
                    }
                    return null;
                }
            }
            entry = bundle.getNextJarEntry();
        }
        ArrayList result = new ArrayList();
        Iterator iter = certificateChains.iterator();
        while (iter.hasNext()) {
            result.addAll((List)iter.next());
        }
        return result.toArray(new X509Certificate[result.size()]);
    }

    private boolean isRevoked(Certificate certificate) {
        Iterator iter = this.m_manager.getCRLs().iterator();
        while (iter.hasNext()) {
            if (!((CRL)iter.next()).isRevoked(certificate)) continue;
            return true;
        }
        return false;
    }

    private void getRootChains(Certificate[] certificates, List chains, boolean check) {
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        boolean revoked = false;
        for (int i = 0; i < certificates.length - 1; ++i) {
            X509Certificate certificate = (X509Certificate)certificates[i];
            if (!revoked && this.isRevoked(certificate)) {
                revoked = true;
            }
            if (!check || !revoked) {
                try {
                    if (check) {
                        certificate.checkValidity();
                    }
                    chain.add(certificate);
                }
                catch (CertificateException ex) {
                    this.m_logger.log(2, "Invalid Certificate", (Throwable)ex);
                    revoked = true;
                }
            }
            if (((Object)((X509Certificate)certificates[i + 1]).getSubjectDN()).equals(certificate.getIssuerDN())) continue;
            if (!check || !revoked && this.trusted(certificate)) {
                chains.add(chain);
            }
            revoked = false;
            if (chain.isEmpty()) continue;
            chain = new ArrayList();
        }
        if (!check || !revoked) {
            chain.add(certificates[certificates.length - 1]);
            if (!check || this.trusted((X509Certificate)certificates[certificates.length - 1])) {
                chains.add(chain);
            }
        }
    }

    private boolean trusted(X509Certificate cert) {
        X509Certificate trustedCaCert;
        if (this.m_manager.getCaCerts().isEmpty() || this.isRevoked(cert)) {
            return false;
        }
        Iterator iter = this.m_manager.getCaCerts().iterator();
        while (iter.hasNext()) {
            trustedCaCert = (X509Certificate)iter.next();
            if (this.isRevoked(trustedCaCert) || !((Object)cert.getSubjectDN()).equals(trustedCaCert.getSubjectDN()) || !cert.equals(trustedCaCert)) continue;
            try {
                cert.checkValidity();
                trustedCaCert.checkValidity();
                return true;
            }
            catch (CertificateException ex) {
                this.m_logger.log(2, "Invalid Certificate", (Throwable)ex);
            }
        }
        iter = this.m_manager.getCaCerts().iterator();
        while (iter.hasNext()) {
            trustedCaCert = (X509Certificate)iter.next();
            if (this.isRevoked(trustedCaCert) || !((Object)cert.getIssuerDN()).equals(trustedCaCert.getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCert.getPublicKey());
                cert.checkValidity();
                trustedCaCert.checkValidity();
                return true;
            }
            catch (Exception ex) {
                this.m_logger.log(2, "Invalid Certificate", (Throwable)ex);
            }
        }
        return false;
    }

    static {
        Method getCodeSigners = null;
        Method getSignerCertPath = null;
        Method getCertificates = null;
        try {
            getCodeSigners = Class.forName("java.util.jar.JarEntry").getMethod("getCodeSigners", null);
            getSignerCertPath = Class.forName("java.security.CodeSigner").getMethod("getSignerCertPath", null);
            getCertificates = Class.forName("java.security.cert.CertPath").getMethod("getCertificates", null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            getCodeSigners = null;
            getSignerCertPath = null;
            getCertificates = null;
        }
        m_getCodeSigners = getCodeSigners;
        m_getSignerCertPath = getSignerCertPath;
        m_getCertificates = getCertificates;
    }
}

