/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.jmx;

import java.util.ArrayList;
import javax.jms.JMSException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ManagementContext
implements Service {
    public static String DEFAULT_DOMAIN = "org.apache.activemq";
    private static final Log log = LogFactory.getLog(ManagementContext.class);
    private MBeanServer beanServer;
    private String jmxDomainName = DEFAULT_DOMAIN;
    private boolean useMBeanServer = true;
    private boolean createMBeanServer = true;
    private boolean locallyCreateMBeanServer = false;

    public ManagementContext() {
        this(null);
    }

    public ManagementContext(MBeanServer server) {
        this.beanServer = server;
    }

    public void start() throws JMSException {
        this.getMBeanServer();
    }

    public void stop() throws JMSException {
        ArrayList<MBeanServer> list;
        if (this.locallyCreateMBeanServer && this.beanServer != null && (list = MBeanServerFactory.findMBeanServer(null)) != null && !list.isEmpty() && list.contains(this.beanServer)) {
            MBeanServerFactory.releaseMBeanServer(this.beanServer);
        }
    }

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public MBeanServer getMBeanServer() {
        if (this.beanServer == null) {
            this.beanServer = this.findMBeanServer();
        }
        return this.beanServer;
    }

    public boolean isUseMBeanServer() {
        return this.useMBeanServer;
    }

    public void setUseMBeanServer(boolean useMBeanServer) {
        this.useMBeanServer = useMBeanServer;
    }

    public boolean isCreateMBeanServer() {
        return this.createMBeanServer;
    }

    public void setCreateMBeanServer(boolean enableJMX) {
        this.createMBeanServer = enableJMX;
    }

    public ObjectName createCustomComponentMBeanName(String type, String name) {
        ObjectName result = null;
        String tmp = this.jmxDomainName + ":" + "type=" + ManagementContext.sanitizeString((String)type) + ",name=" + ManagementContext.sanitizeString((String)name);
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)("Couldn't create ObjectName from: " + type + " , " + name));
        }
        return result;
    }

    private static String sanitizeString(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
        }
        return result;
    }

    public static ObjectName getSystemObjectName(String domainName, String containerName, Class theClass) throws MalformedObjectNameException, NullPointerException {
        String tmp = domainName + ":" + "type=" + theClass.getName() + ",name=" + ManagementContext.getRelativeName((String)containerName, (Class)theClass);
        return new ObjectName(tmp);
    }

    private static String getRelativeName(String containerName, Class theClass) {
        String name = theClass.getName();
        int index = name.lastIndexOf(".");
        if (index >= 0 && index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        return containerName + "." + name;
    }

    public void unregisterMBean(ObjectName name) throws JMException {
        if (this.beanServer != null && this.beanServer.isRegistered(name)) {
            this.beanServer.unregisterMBean(name);
        }
    }

    protected synchronized MBeanServer findMBeanServer() {
        MBeanServer result = null;
        try {
            ArrayList<MBeanServer> list;
            if (this.useMBeanServer && (list = MBeanServerFactory.findMBeanServer(null)) != null && list.size() > 0) {
                result = (MBeanServer)list.get(0);
            }
            if (result == null && this.createMBeanServer) {
                result = MBeanServerFactory.createMBeanServer(this.jmxDomainName);
                this.locallyCreateMBeanServer = true;
            }
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)"Couldnot load MBeanServer", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to initialize MBeanServer", e);
        }
        return result;
    }
}

