/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.jmx;

import java.io.IOException;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.web.jmx.JMXServletSupport;
import org.apache.servicemix.web.jmx.JMXWriter;

public class JMXServlet
extends JMXServletSupport {
    private static final Log log = LogFactory.getLog(JMXServlet.class);
    private static final long serialVersionUID = -5953322364144161756L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MBeanServer beanServer = this.getMBeanServer();
            ObjectName name = this.getObjectName(request);
            QueryExp query = this.getQueryExp(request);
            JMXWriter writer = new JMXWriter(response.getWriter(), this.getManagementContext());
            String style = request.getParameter("style");
            String view = request.getParameter("view");
            if (view == null) {
                view = "";
            }
            if (style != null && style.equals("html")) {
                Set<ObjectName> names = beanServer.queryNames(name, query);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ObjectName: " + name));
                    log.debug((Object)("Query: " + query));
                    log.debug((Object)("Matches ObjectNames: " + names));
                }
                if (view.equals("properties")) {
                    writer.outputHtmlProperties(names);
                } else if (view.equals("attributes")) {
                    writer.outputHtmlAttributes(names);
                } else if (view.equals("flat")) {
                    writer.outputHtmlNames(names);
                } else {
                    writer.outputHtmlNamesByDomain(names);
                }
            } else {
                writer.outputHeader();
                if (view.equals("bean")) {
                    Set<ObjectInstance> mbeans = beanServer.queryMBeans(name, query);
                    writer.outputMBeans(mbeans);
                } else if (view.equals("detail")) {
                    Set<ObjectName> names = beanServer.queryNames(name, query);
                    writer.outputDetail(names);
                } else {
                    Set<ObjectName> names = beanServer.queryNames(name, query);
                    writer.outputNames(names);
                }
                writer.outputFooter();
            }
        }
        catch (JMException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

