/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web;

import java.util.Arrays;
import java.util.List;
import javax.jbi.messaging.MessageExchange;
import org.apache.servicemix.jbi.audit.AuditorException;
import org.apache.servicemix.jbi.audit.AuditorMBean;
import org.apache.servicemix.web.Auditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Auditor {
    private AuditorMBean mbean;
    private int page;
    private String exchangeId;

    public Auditor(AuditorMBean mbean) {
        this.mbean = mbean;
    }

    public String getStatus() {
        String status = this.mbean.getCurrentState();
        return status;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    public int getCount() throws AuditorException {
        int count = this.mbean.getExchangeCount();
        return count;
    }

    public List<ExchangeInfo> getExchanges() throws AuditorException {
        MessageExchange[] exchanges = this.mbean.getExchangesByRange(this.page * 10, Math.min((this.page + 1) * 10, this.getCount()));
        ExchangeInfo[] infos = this.prepare(exchanges);
        return Arrays.asList(infos);
    }

    public ExchangeInfo getSelectedExchange() throws AuditorException {
        if (this.exchangeId == null) {
            return null;
        }
        MessageExchange exchange = this.mbean.getExchangeById(this.exchangeId);
        if (exchange != null) {
            return new ExchangeInfo(exchange);
        }
        return null;
    }

    private ExchangeInfo[] prepare(MessageExchange[] exchanges) {
        ExchangeInfo[] infos = new ExchangeInfo[exchanges.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new ExchangeInfo(exchanges[i]);
        }
        return infos;
    }
}

