/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.controller;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicemix.jbi.view.DotViewServiceMBean;
import org.apache.servicemix.web.view.DotView;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.Controller;

public class DotViewController
implements Controller {
    public static final String TYPE_FLOW = "flow";
    public static final String TYPE_ENDPOINTS = "endpoints";
    private DotViewServiceMBean mbean;
    private String type;
    private DotView view;

    public DotViewController(DotViewServiceMBean mbean) {
        this.mbean = mbean;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dotSrc;
        if (TYPE_FLOW.equals(this.getType())) {
            dotSrc = this.mbean.createFlowGraph();
        } else if (TYPE_ENDPOINTS.equals(this.getType())) {
            dotSrc = this.mbean.createEndpointGraph();
        } else {
            throw new IllegalStateException("Unknown type: " + this.getType());
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put(this.view.getDotModelSource(), dotSrc);
        return new ModelAndView((View)this.getView(), model);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DotView getView() {
        return this.view;
    }

    public void setView(DotView view) {
        this.view = view;
    }
}

