/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.controller;

import javax.jbi.management.LifeCycleMBean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class ServiceLifeCycle
implements Controller {
    public static final String START = "start";
    public static final String STOP = "stop";
    public static final String SHUTDOWN = "shutdown";
    private LifeCycleMBean serviceMBean;
    private String name;
    private String view;
    private String action;

    public ServiceLifeCycle(LifeCycleMBean serviceMBean, String action) {
        if (serviceMBean == null) {
            throw new IllegalArgumentException("serviceMBean is null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        if (!(START.equals(action) || STOP.equals(action) || SHUTDOWN.equals(action))) {
            throw new IllegalArgumentException("action must be start, stop, shutdown");
        }
        this.serviceMBean = serviceMBean;
        this.action = action;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (START.equals(this.action)) {
            this.serviceMBean.start();
        } else if (STOP.equals(this.action)) {
            this.serviceMBean.stop();
        } else if (SHUTDOWN.equals(this.action)) {
            this.serviceMBean.shutDown();
        }
        return new ModelAndView(this.getView());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }
}

