/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.http;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jbi.component.Component;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HttpManagedServlet
extends HttpServlet {
    public static final String CONTAINER_PROPERTY = "container";
    public static final String CONTAINER_DEFAULT = "jbi";
    public static final String COMPONENT_PROPERTY = "component";
    public static final String COMPONENT_DEFAULT = "servicemix-http";
    public static final String MAPPING_PROPERTY = "mapping";
    private JBIContainer container;
    private Object processor;
    private Method processorMethod;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        String containerName = config.getInitParameter(CONTAINER_PROPERTY);
        if (containerName == null) {
            containerName = CONTAINER_DEFAULT;
        }
        this.container = (JBIContainer)applicationContext.getBean(containerName);
        if (this.container == null) {
            throw new IllegalStateException("Unable to find jbi container " + containerName);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.processor == null) {
                ComponentMBeanImpl mbean;
                String componentName = this.getServletConfig().getInitParameter(COMPONENT_PROPERTY);
                if (componentName == null) {
                    componentName = COMPONENT_DEFAULT;
                }
                if ((mbean = this.container.getComponent(componentName)) == null) {
                    throw new ServletException("Component " + componentName + " not installed");
                }
                Component component = mbean.getComponent();
                Method mth = component.getClass().getMethod("getMainProcessor", null);
                this.processor = mth.invoke((Object)component, (Object[])null);
                this.processorMethod = this.processor.getClass().getMethod("process", HttpServletRequest.class, HttpServletResponse.class);
            }
            this.processorMethod.invoke(this.processor, request, response);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new ServletException("Failed to process request: " + e.getTargetException(), e.getTargetException());
        }
        catch (Exception e) {
            throw new ServletException("Failed to process request: " + e, (Throwable)e);
        }
    }
}

