/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.jmx;

import java.io.IOException;
import java.util.Iterator;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.jmx.access.MBeanInfoRetrievalException;
import org.springframework.jmx.access.MBeanProxyFactoryBean;

public class EnhancedMBeanProxyFactoryBean
extends MBeanProxyFactoryBean {
    private static final Log LOG = LogFactory.getLog(EnhancedMBeanProxyFactoryBean.class);
    protected static final String WEBSPHERE = "WebSphere";
    private MBeanServerConnection connection;
    private String originalName;

    public void afterPropertiesSet() throws MBeanServerNotFoundException, MBeanInfoRetrievalException {
        block3: {
            try {
                if (WEBSPHERE.equals(this.connection.getDefaultDomain())) {
                    this.doWebSphereConfiguration();
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Unable to determine default domain name - assuming it's not WebSphere", (Throwable)e);
            }
        }
        super.afterPropertiesSet();
    }

    private void doWebSphereConfiguration() {
        LOG.info((Object)("Running on WebSphere - adding cell/node/process information to " + this.originalName));
        try {
            String cell = null;
            String node = null;
            String process = null;
            Iterator<ObjectName> i$ = this.connection.queryNames(new ObjectName("WebSphere:name=JVM,*"), null).iterator();
            while (i$.hasNext()) {
                ObjectName value;
                ObjectName objectName = value = i$.next();
                cell = objectName.getKeyProperty("cell");
                node = objectName.getKeyProperty("node");
                process = objectName.getKeyProperty("process");
            }
            String name = String.format("%s,cell=%s,node=%s,process=%s", this.originalName, cell, node, process);
            super.setObjectName((Object)name);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Object name has been changed to " + name));
            }
        }
        catch (MalformedObjectNameException e) {
            throw new MBeanInfoRetrievalException("Unable to determine cell/node/process information while running in WebSphere", (Throwable)e);
        }
        catch (IOException e) {
            throw new MBeanInfoRetrievalException("Unable to determine cell/node/process information while running in WebSphere", (Throwable)e);
        }
    }

    public void setServer(MBeanServerConnection connection) {
        this.connection = connection;
        super.setServer(connection);
    }

    public void setObjectName(Object name) throws MalformedObjectNameException {
        this.originalName = name != null ? name.toString() : null;
        super.setObjectName(name);
    }
}

