/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.jmx;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.servicemix.web.jmx.ManagementContext;

public abstract class JMXServletSupport
extends HttpServlet {
    protected static final String MANAGEMENT_CONTEXT_PROPERTY = "org.activemq.jmx.ManagementContext";
    private ManagementContext managementContext;

    public void init() throws ServletException {
        if (this.managementContext == null) {
            this.managementContext = (ManagementContext)this.getServletContext().getAttribute(MANAGEMENT_CONTEXT_PROPERTY);
            if (this.managementContext == null) {
                this.managementContext = new ManagementContext();
            }
        }
    }

    public MBeanServer getMBeanServer() {
        return this.managementContext.getMBeanServer();
    }

    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    public void setManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    protected QueryExp getQueryExp(HttpServletRequest request) throws ServletException {
        ObjectName answer = null;
        String value = request.getParameter("query");
        if (value != null) {
            try {
                answer = new ObjectName(value);
            }
            catch (MalformedObjectNameException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return answer;
    }

    protected ObjectName getObjectName(HttpServletRequest request) throws ServletException {
        String value = request.getParameter("name");
        ObjectName answer = null;
        if (value != null) {
            try {
                answer = new ObjectName(value);
            }
            catch (MalformedObjectNameException e) {
                throw new ServletException("Failed to parse object name: " + value + ". Reason: " + e, (Throwable)e);
            }
        }
        return answer;
    }

    protected boolean asBoolean(HttpServletRequest request, String name) {
        String param = request.getParameter(name);
        return param != null && param.equalsIgnoreCase("true");
    }
}

