/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.model;

import java.util.List;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.framework.ComponentMBean;
import org.apache.servicemix.web.model.Endpoint;
import org.apache.servicemix.web.model.Registry;
import org.apache.servicemix.web.model.ServiceUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component {
    private final Registry registry;
    private final ComponentMBean mbean;
    private final ObjectName objectName;

    public Component(Registry registry, ComponentMBean mbean, ObjectName objectName) {
        this.registry = registry;
        this.mbean = mbean;
        this.objectName = objectName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getName() {
        return this.objectName.getKeyProperty("Name");
    }

    public String getType() {
        return this.mbean.getComponentType();
    }

    public String getStatus() throws Exception {
        return this.mbean.getCurrentState();
    }

    public List<ServiceUnit> getServiceUnits() throws Exception {
        return this.registry.getServiceUnits(this);
    }

    public List<Endpoint> getEndpoints() throws Exception {
        return this.registry.getEndpoints(this);
    }

    public boolean equals(Object o) {
        if (o instanceof Component) {
            return ((Component)o).objectName.equals(this.objectName);
        }
        return false;
    }

    public int hashCode() {
        return this.objectName.hashCode();
    }
}

