/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.framework.EndpointMBean;
import org.apache.servicemix.web.model.Component;
import org.apache.servicemix.web.model.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Endpoint {
    private Registry registry;
    private EndpointMBean mbean;
    private ObjectName objectName;
    private boolean showWsdl;

    public Endpoint(Registry registry, EndpointMBean mbean, ObjectName objectName) {
        this.registry = registry;
        this.mbean = mbean;
        this.objectName = objectName;
    }

    public String getName() {
        return this.mbean.getServiceName() + ":" + this.mbean.getEndpointName();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getType() throws Exception {
        return this.objectName.getKeyProperty("SubType");
    }

    public Component getComponent() throws Exception {
        return this.registry.getComponent(this.mbean.getComponentName());
    }

    public boolean equals(Object o) {
        if (o instanceof Endpoint) {
            return ((Endpoint)o).objectName.equals(this.objectName);
        }
        return false;
    }

    public int hashCode() {
        return this.objectName.hashCode();
    }

    public boolean isShowWsdl() {
        return this.showWsdl;
    }

    public void setShowWsdl(boolean showWsdl) {
        this.showWsdl = showWsdl;
    }

    public String getWsdl() {
        return this.mbean.loadWSDL().replace("<", "&lt;");
    }

    public List<QName> getInterfaces() {
        QName[] names = this.mbean.getInterfaces();
        if (names != null) {
            return Arrays.asList(names);
        }
        return Collections.emptyList();
    }
}

