/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.model;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.servicemix.web.jmx.EnhancedMBeanProxyFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyManager {
    private final MBeanServerConnection server;
    private final Map<ObjectName, Reference<Object>> proxies = new ConcurrentHashMap();

    public ProxyManager(MBeanServerConnection server) {
        this.server = server;
    }

    public <T> T getProxy(ObjectName name, Class<T> type) {
        Object proxy;
        Reference r = (Reference)this.proxies.get(name);
        Object object = proxy = r != null ? (Object)r.get() : null;
        if (proxy == null) {
            EnhancedMBeanProxyFactoryBean factory = new EnhancedMBeanProxyFactoryBean();
            factory.setServer(this.server);
            try {
                factory.setObjectName((Object)name);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalStateException(e);
            }
            factory.setProxyInterface(type);
            factory.setUseStrictCasing(false);
            factory.afterPropertiesSet();
            proxy = factory.getObject();
            this.proxies.put(name, new SoftReference<Object>(proxy));
        }
        return (T)proxy;
    }
}

