/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.model;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.framework.ComponentMBean;
import org.apache.servicemix.jbi.framework.EndpointMBean;
import org.apache.servicemix.jbi.framework.RegistryMBean;
import org.apache.servicemix.jbi.framework.ServiceAssemblyMBean;
import org.apache.servicemix.jbi.framework.ServiceUnitMBean;
import org.apache.servicemix.jbi.framework.SharedLibraryMBean;
import org.apache.servicemix.web.model.Component;
import org.apache.servicemix.web.model.Endpoint;
import org.apache.servicemix.web.model.ProxyManager;
import org.apache.servicemix.web.model.ServiceAssembly;
import org.apache.servicemix.web.model.ServiceUnit;
import org.apache.servicemix.web.model.SharedLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    private final RegistryMBean mbean;
    private final ProxyManager proxyManager;

    public Registry(RegistryMBean mbean, ProxyManager proxyManager) {
        this.mbean = mbean;
        this.proxyManager = proxyManager;
    }

    public List<Component> getComponents() {
        ArrayList<Component> components = new ArrayList<Component>();
        ObjectName[] names = this.mbean.getComponentNames();
        for (int i = 0; i < names.length; ++i) {
            ComponentMBean mbean = (ComponentMBean)this.proxyManager.getProxy(names[i], ComponentMBean.class);
            if ("#SubscriptionManager#".equals(mbean.getName())) continue;
            components.add(new Component(this, mbean, names[i]));
        }
        return components;
    }

    public Component getComponent(String name) {
        for (Component component : this.getComponents()) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    public List<Component> getComponent(SharedLibrary library) {
        ArrayList components = new ArrayList();
        for (Component component : this.getComponents()) {
        }
        return null;
    }

    public List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        ObjectName[] names = this.mbean.getEndpointNames();
        for (int i = 0; i < names.length; ++i) {
            EndpointMBean mbean = (EndpointMBean)this.proxyManager.getProxy(names[i], EndpointMBean.class);
            endpoints.add(new Endpoint(this, mbean, names[i]));
        }
        return endpoints;
    }

    public Endpoint getEndpoint(ObjectName objectName) {
        for (Endpoint endpoint : this.getEndpoints()) {
            if (!endpoint.getObjectName().equals(objectName)) continue;
            return endpoint;
        }
        return null;
    }

    public List<Endpoint> getEndpoints(Component component) throws Exception {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : this.getEndpoints()) {
            if (!component.equals((Object)endpoint.getComponent())) continue;
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public List<ServiceUnit> getServiceUnits() {
        ArrayList<ServiceUnit> serviceUnits = new ArrayList<ServiceUnit>();
        ObjectName[] names = this.mbean.getServiceUnitNames();
        for (int i = 0; i < names.length; ++i) {
            ServiceUnitMBean mbean = (ServiceUnitMBean)this.proxyManager.getProxy(names[i], ServiceUnitMBean.class);
            serviceUnits.add(new ServiceUnit(this, mbean, names[i]));
        }
        return serviceUnits;
    }

    public ServiceUnit getServiceUnit(String name) {
        for (ServiceUnit serviceUnit : this.getServiceUnits()) {
            if (!serviceUnit.getName().equals(name)) continue;
            return serviceUnit;
        }
        return null;
    }

    public List<ServiceUnit> getServiceUnits(Component component) {
        ArrayList<ServiceUnit> serviceUnits = new ArrayList<ServiceUnit>();
        for (ServiceUnit serviceUnit : this.getServiceUnits()) {
            if (!serviceUnit.getComponent().equals((Object)component)) continue;
            serviceUnits.add(serviceUnit);
        }
        return serviceUnits;
    }

    public List<ServiceUnit> getServiceUnits(ServiceAssembly assembly) {
        ArrayList<ServiceUnit> serviceUnits = new ArrayList<ServiceUnit>();
        for (ServiceUnit serviceUnit : this.getServiceUnits()) {
            if (!serviceUnit.getServiceAssembly().equals((Object)assembly)) continue;
            serviceUnits.add(serviceUnit);
        }
        return serviceUnits;
    }

    public List<ServiceAssembly> getServiceAssemblies() {
        ArrayList<ServiceAssembly> serviceAssemblies = new ArrayList<ServiceAssembly>();
        ObjectName[] names = this.mbean.getServiceAssemblyNames();
        for (int i = 0; i < names.length; ++i) {
            ServiceAssemblyMBean mbean = (ServiceAssemblyMBean)this.proxyManager.getProxy(names[i], ServiceAssemblyMBean.class);
            serviceAssemblies.add(new ServiceAssembly(this, mbean, names[i]));
        }
        return serviceAssemblies;
    }

    public ServiceAssembly getServiceAssembly(String name) {
        List serviceAssemblies = this.getServiceAssemblies();
        for (ServiceAssembly serviceAssembly : serviceAssemblies) {
            if (!serviceAssembly.getName().equals(name)) continue;
            return serviceAssembly;
        }
        return null;
    }

    public List<SharedLibrary> getSharedLibraries() {
        ArrayList<SharedLibrary> sharedLibraries = new ArrayList<SharedLibrary>();
        ObjectName[] names = this.mbean.getSharedLibraryNames();
        for (int i = 0; i < names.length; ++i) {
            SharedLibraryMBean mbean = (SharedLibraryMBean)this.proxyManager.getProxy(names[i], SharedLibraryMBean.class);
            sharedLibraries.add(new SharedLibrary(this, mbean, names[i]));
        }
        return sharedLibraries;
    }

    public SharedLibrary getSharedLibrary(String name) {
        for (SharedLibrary sharedLibrary : this.getSharedLibraries()) {
            if (!sharedLibrary.getName().equals(name)) continue;
            return sharedLibrary;
        }
        return null;
    }
}

