/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.model;

import javax.management.ObjectName;
import org.apache.servicemix.jbi.framework.ServiceUnitMBean;
import org.apache.servicemix.web.model.Component;
import org.apache.servicemix.web.model.Registry;
import org.apache.servicemix.web.model.ServiceAssembly;

public class ServiceUnit {
    private Registry registry;
    private ServiceUnitMBean mbean;
    private ObjectName objectName;

    public ServiceUnit(Registry registry, ServiceUnitMBean mbean, ObjectName objectName) {
        this.registry = registry;
        this.mbean = mbean;
        this.objectName = objectName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getName() {
        return this.objectName.getKeyProperty("Name");
    }

    public Component getComponent() {
        return this.registry.getComponent(this.mbean.getComponentName());
    }

    public ServiceAssembly getServiceAssembly() {
        return this.registry.getServiceAssembly(this.mbean.getServiceAssembly());
    }

    public String getStatus() {
        return this.mbean.getCurrentState();
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceUnit) {
            return ((ServiceUnit)o).objectName.equals(this.objectName);
        }
        return false;
    }

    public int hashCode() {
        return this.objectName.hashCode();
    }
}

