/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicemix.jbi.util.FileUtil;
import org.apache.servicemix.web.view.Dot;
import org.springframework.web.servlet.view.AbstractView;

public class DotView
extends AbstractView {
    public static final String DEFAULT_DOT_FORMAT = "svg";
    public static final String MODEL_SOURCE = "dotSource";
    public static final String MODEL_FORMAT = "dotFormat";
    private String dotModelSource = "dotSource";
    private String dotFormat = "svg";
    private static final Map<String, String> FORMATS = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object o = model.get(this.getDotModelSource());
        if (o == null) {
            throw new IllegalStateException("Dot model source not found in '" + this.getDotModelSource() + "'");
        }
        if (FORMATS.get(this.getDotFormat()) == null) {
            throw new IllegalStateException("Unknown format: '" + this.getDotFormat() + "'");
        }
        File dotSrc = null;
        File dotImg = null;
        try {
            dotSrc = File.createTempFile("smx_", ".dot");
            FileWriter w = new FileWriter(dotSrc);
            w.write(o.toString());
            w.close();
            dotImg = new File(dotSrc.getAbsolutePath() + "." + this.getDotFormat());
            String cmd = System.getProperty("os.name").contains("Windows") ? "-T" + this.getDotFormat() + " \"" + dotSrc.getAbsolutePath() + "\" -o\"" + dotImg.getAbsolutePath() + "\"" : "-T " + this.getDotFormat() + " " + dotSrc.getAbsolutePath() + " -o " + dotImg.getAbsolutePath();
            Dot.run((String)cmd);
            FileInputStream is = new FileInputStream(dotImg);
            if (((InputStream)is).available() == 0) {
                throw new Exception("Error while rendering dot file");
            }
            response.setContentType(this.getContentType());
            response.setContentLength(((InputStream)is).available());
            FileUtil.copyInputStream((InputStream)is, (OutputStream)response.getOutputStream());
        }
        finally {
            if (dotSrc != null) {
                dotSrc.delete();
            }
            if (dotImg != null) {
                dotImg.delete();
            }
        }
    }

    public String getContentType() {
        return (String)FORMATS.get(this.getDotFormat());
    }

    public String getDotFormat() {
        return this.dotFormat;
    }

    public void setDotFormat(String dotFormat) {
        this.dotFormat = dotFormat;
    }

    public String getDotModelSource() {
        return this.dotModelSource;
    }

    public void setDotModelSource(String dotModelSource) {
        this.dotModelSource = dotModelSource;
    }

    static {
        FORMATS.put(DEFAULT_DOT_FORMAT, "image/svg+xml");
        FORMATS.put("gif", "image/gif");
        FORMATS.put("jpg", "image/jpeg");
    }
}

