/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.web.jmx;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.web.jmx.ManagementContext;

public class JMXWriter {
    private static final Log log = LogFactory.getLog(JMXWriter.class);
    private PrintWriter writer;
    private ManagementContext managementContext;
    private String unknownValue = "Unknown";

    public JMXWriter(PrintWriter writer, ManagementContext context) {
        this.writer = writer;
        this.managementContext = context;
    }

    public MBeanServer getMBeanServer() {
        return this.managementContext.getMBeanServer();
    }

    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    public void setManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    public void outputHtmlNamesByDomain(Collection names) throws IOException {
        String domain;
        TreeMap<String, ArrayList<ObjectName>> map = new TreeMap<String, ArrayList<ObjectName>>();
        for (ObjectName objectName : names) {
            domain = objectName.getDomain();
            ArrayList<ObjectName> list = (ArrayList<ObjectName>)map.get(domain);
            if (list == null) {
                list = new ArrayList<ObjectName>();
                map.put(domain, list);
            }
            list.add(objectName);
        }
        for (Map.Entry entry : map.entrySet()) {
            domain = (String)entry.getKey();
            names = (List)entry.getValue();
            this.writer.print("<li>");
            this.writer.print(domain);
            this.writer.print("<ul>");
            this.outputHtmlNamesByProperty(names, "Type");
            this.writer.print("</ul>");
            this.writer.print("</li>");
        }
    }

    public void outputHtmlNamesByProperty(Collection names, String property) throws IOException {
        String propertyValue;
        TreeMap<String, ArrayList<ObjectName>> map = new TreeMap<String, ArrayList<ObjectName>>();
        for (ObjectName objectName : names) {
            ArrayList<ObjectName> list;
            propertyValue = objectName.getKeyProperty(property);
            if (propertyValue == null) {
                propertyValue = this.unknownValue;
            }
            if ((list = (ArrayList<ObjectName>)map.get(propertyValue)) == null) {
                list = new ArrayList<ObjectName>();
                map.put(propertyValue, list);
            }
            list.add(objectName);
        }
        for (Map.Entry entry : map.entrySet()) {
            propertyValue = (String)entry.getKey();
            names = (List)entry.getValue();
            if (names.size() > 1) {
                this.writer.print("<li><a href='");
                this.printDetailURL(property, propertyValue);
                this.writer.print("'>");
                this.writer.print(propertyValue);
                this.writer.print("</a><ul>");
                this.outputHtmlNamesSortedByShortName(names);
                this.writer.print("</ul>");
                this.writer.print("</li>");
                continue;
            }
            if (names.size() != 1) continue;
            ObjectName name = (ObjectName)((List)names).get(0);
            this.outputHtmlName(name, propertyValue);
        }
    }

    public void outputHtmlNamesSortedByShortName(Collection names) throws IOException {
        TreeMap<String, ObjectName> map = new TreeMap<String, ObjectName>();
        for (ObjectName objectName : names) {
            String propertyValue = this.getShortName(objectName);
            map.put(propertyValue, objectName);
        }
        for (Map.Entry entry : map.entrySet()) {
            String description = (String)entry.getKey();
            ObjectName name = (ObjectName)entry.getValue();
            this.outputHtmlName(name, description);
        }
    }

    public void outputHtmlNames(Collection names) throws IOException {
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            this.outputHtmlNames((ObjectName)iter.next());
        }
    }

    public void outputHtmlNames(ObjectName name) throws IOException {
        this.outputHtmlName(name, this.getShortName(name));
    }

    public void outputHtmlName(ObjectName name, String shortName) throws IOException {
        this.writer.print("<li><a href='");
        this.printDetailURL(name);
        this.writer.print("'>");
        this.writer.print(shortName);
        this.writer.print("</a></li>");
    }

    protected String getShortName(ObjectName name) {
        String answer = name.toString();
        int idx = answer.indexOf(58);
        if (idx >= 0) {
            return answer.substring(idx + 1);
        }
        return answer;
    }

    public void outputNames(Collection names) throws IOException {
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            this.outputNames((ObjectName)iter.next());
        }
    }

    public void outputNames(ObjectName name) throws IOException {
        this.writer.print("<mbean name='");
        this.writer.print(name.getCanonicalName());
        this.writer.print("' domain='");
        this.writer.print(name.getDomain());
        this.writer.println("'>");
        Hashtable<String, String> properties = name.getKeyPropertyList();
        for (Map.Entry entry : properties.entrySet()) {
            this.writer.print("<property name='");
            this.writer.print(entry.getKey());
            this.writer.print("'>");
            this.writer.print(entry.getValue());
            this.writer.println("</property>");
        }
        this.writer.println("</mbean>");
    }

    public void outputDetail(Set names) throws IOException, JMException {
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            this.outputDetail((ObjectName)iter.next());
        }
    }

    public void outputDetail(ObjectName name) throws JMException, IOException {
        MBeanServer beanServer = this.getMBeanServer();
        MBeanInfo beanInfo = beanServer.getMBeanInfo(name);
        this.writer.print("<mbean name='");
        this.writer.print(name.getCanonicalName());
        this.writer.print("' domain='");
        this.writer.print(name.getDomain());
        this.writer.println("'>");
        MBeanAttributeInfo[] attributes = beanInfo.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            String attributeName;
            Object value;
            MBeanAttributeInfo info = attributes[i];
            if (!info.isReadable() || (value = this.getAttributeValue(name, attributeName = info.getName())) == null) continue;
            this.writer.print("<attribute name='");
            this.writer.print(attributeName);
            this.writer.print("' type='");
            this.writer.print(info.getType());
            this.writer.print("'>");
            this.printEncodedValue(value);
            this.writer.println("</attribute>");
        }
        this.writer.println("</mbean>");
    }

    public void outputHtmlProperties(Set names) throws JMException, IOException {
        if (names.size() <= 1) {
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                this.outputHtmlProperties((ObjectName)iter.next());
            }
        } else {
            this.outputHtmlPropertiesGrid(names);
        }
    }

    public void outputHtmlPropertiesGrid(Set names) throws JMException {
        TreeSet<String> propertyNames = new TreeSet<String>();
        Map[] propertyNamesPerMBeanArray = new Map[names.size()];
        int beanCounter = 0;
        for (ObjectName name : names) {
            Hashtable<String, String> keyMap = name.getKeyPropertyList();
            propertyNamesPerMBeanArray[beanCounter++] = keyMap;
            propertyNames.addAll(keyMap.keySet());
        }
        this.writer.println("<table>");
        this.writer.println("<tr>");
        this.writer.print("<th>Domain</th>");
        Iterator iter = propertyNames.iterator();
        while (iter.hasNext()) {
            this.writer.print("<th>");
            this.writer.print(iter.next());
            this.writer.print("</th>");
        }
        this.writer.println();
        this.writer.println("</tr>");
        beanCounter = 0;
        for (ObjectName name : names) {
            this.writer.print("<tr><td class='domainName'>");
            this.writer.print(name.getDomain());
            this.writer.print("</td>");
            for (String propertyName : propertyNames) {
                if (!propertyNamesPerMBeanArray[beanCounter].containsKey(propertyName)) continue;
                String value = name.getKeyProperty(propertyName);
                this.writer.print("<td class='");
                this.writer.print(propertyName);
                this.writer.print("'>");
                if (value != null) {
                    this.printEncodedValue((Object)value);
                }
                this.writer.print("</td>");
            }
            this.writer.print("</tr>");
            ++beanCounter;
        }
        this.writer.println("</table>");
    }

    public void outputHtmlProperties(ObjectName name) throws JMException, IOException {
        this.writer.println("<table>");
        this.writer.println("<tr>");
        this.writer.println("<th>Property</th><th>Value</th>");
        this.writer.println("</tr>");
        this.writer.print("<tr><td>Domain</td><td>");
        String domain = name.getDomain();
        if (domain != null) {
            this.printEncodedValue((Object)domain);
        }
        this.writer.print("</td></tr>");
        Hashtable<String, String> map = name.getKeyPropertyList();
        for (Map.Entry entry : map.entrySet()) {
            String attributeName = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.writer.print("<tr><td>");
            this.writer.print(attributeName);
            this.writer.print("</td><td>");
            if (value != null) {
                this.printEncodedValue((Object)value);
            }
            this.writer.print("</td></tr>");
        }
        this.writer.println("</table>");
    }

    public void outputHtmlAttributes(Set names) throws IOException, JMException {
        if (names.size() <= 1) {
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                this.outputHtmlAttributes((ObjectName)iter.next());
            }
        } else {
            this.outputHtmlAttributeGrid(names);
        }
    }

    public void outputHtmlAttributeGrid(Set names) throws JMException {
        MBeanServer beanServer = this.getMBeanServer();
        TreeSet<String> attributeNames = new TreeSet<String>();
        Set[] attributeNamesPerMBeanArray = new Set[names.size()];
        int beanCounter = 0;
        for (ObjectName name : names) {
            MBeanInfo beanInfo = beanServer.getMBeanInfo(name);
            MBeanAttributeInfo[] attributes = beanInfo.getAttributes();
            HashSet<String> availableNamesPerMBean = new HashSet<String>();
            attributeNamesPerMBeanArray[beanCounter++] = availableNamesPerMBean;
            for (int i = 0; i < attributes.length; ++i) {
                MBeanAttributeInfo info = attributes[i];
                if (!info.isReadable()) continue;
                String attributeName = info.getName();
                availableNamesPerMBean.add(attributeName);
                attributeNames.add(attributeName);
            }
        }
        this.writer.println("<table>");
        this.writer.println("<tr>");
        this.writer.print("<th>MBean</th>");
        Iterator iter = attributeNames.iterator();
        while (iter.hasNext()) {
            this.writer.print("<th>");
            this.writer.print(iter.next());
            this.writer.print("</th>");
        }
        this.writer.println();
        this.writer.println("</tr>");
        beanCounter = 0;
        for (ObjectName name : names) {
            this.writer.print("<tr><td class='mbeanName'>");
            this.writer.print(name);
            this.writer.print("</td>");
            for (String attributeName : attributeNames) {
                if (!attributeNamesPerMBeanArray[beanCounter].contains(attributeName)) continue;
                Object value = this.getAttributeValue(name, attributeName);
                this.writer.print("<td class='");
                this.writer.print(attributeName);
                this.writer.print("'>");
                if (value != null) {
                    this.printEncodedValue(value);
                }
                this.writer.print("</td>");
            }
            this.writer.print("</tr>");
            ++beanCounter;
        }
        this.writer.println("</table>");
    }

    public void outputHtmlAttributes(ObjectName name) throws JMException, IOException {
        MBeanServer beanServer = this.getMBeanServer();
        MBeanInfo beanInfo = beanServer.getMBeanInfo(name);
        this.writer.println("<table>");
        this.writer.println("<tr>");
        this.writer.println("<th>Attribute</th><th>Value</th><th>Type</th>");
        this.writer.println("</tr>");
        MBeanAttributeInfo[] attributes = beanInfo.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            MBeanAttributeInfo info = attributes[i];
            if (!info.isReadable()) continue;
            String attributeName = info.getName();
            Object value = this.getAttributeValue(name, attributeName);
            this.writer.print("<tr><td>");
            this.writer.print(attributeName);
            this.writer.print("</td><td>");
            if (value != null) {
                this.printEncodedValue(value);
            }
            this.writer.print("</td><td>");
            this.writer.print(info.getType());
            this.writer.print("</td></tr>");
        }
        this.writer.println("</table>");
    }

    public void outputMBeans(Collection names) throws IOException {
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            this.outputMBeans((ObjectName)iter.next());
        }
    }

    public void outputMBeans(ObjectName name) throws IOException {
        Hashtable<String, String> properties = name.getKeyPropertyList();
        for (Map.Entry entry : properties.entrySet()) {
            this.writer.print("<mbean name='");
            this.writer.print(entry.getKey());
            ObjectInstance objectInstance = (ObjectInstance)entry.getValue();
            if (objectInstance != null) {
                this.writer.print("' className='");
                this.writer.print(objectInstance.getClassName());
            }
            this.writer.println("'/>");
        }
    }

    public void outputHeader() throws IOException {
        this.writer.println("<?xml version='1.0'?>");
        this.writer.println("<mbeans>");
    }

    public void outputFooter() throws IOException {
        this.writer.println("</mbeans>");
    }

    public void printEncodedValue(Object value) {
        if (value != null) {
            String text = value.toString();
            int size = text.length();
            block8: for (int i = 0; i < size; ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '<': {
                        this.writer.print("&lt;");
                        continue block8;
                    }
                    case '>': {
                        this.writer.print("&gt;");
                        continue block8;
                    }
                    case '&': {
                        this.writer.print("&amp;");
                        continue block8;
                    }
                    case ',': {
                        this.writer.print("%2C");
                        continue block8;
                    }
                    case ':': {
                        this.writer.print("%3A");
                        continue block8;
                    }
                    case '=': {
                        this.writer.print("%3D");
                        continue block8;
                    }
                    default: {
                        this.writer.print(ch);
                    }
                }
            }
        }
    }

    public void printEncodedObjectName(ObjectName name) {
        this.printEncodedValue((Object)name);
    }

    protected void printDetailURL(ObjectName name) {
        this.writer.print("mbeanDetail.jsp?view=detail&style=html&name=");
        this.printEncodedObjectName(name);
    }

    protected void printDetailURL(String propertyName, String propertyValue) {
        this.writer.print("mbeanDetail.jsp?view=detail&style=html&query=");
        this.printEncodedValue((Object)("*:" + propertyName + "=" + propertyValue + ",*"));
    }

    protected Object getAttributeValue(ObjectName name, String attributeName) throws MBeanException {
        MBeanServer beanServer = this.getMBeanServer();
        Object value = null;
        try {
            value = beanServer.getAttribute(name, attributeName);
        }
        catch (AttributeNotFoundException e) {
            log.warn((Object)("Caught: " + e), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            log.warn((Object)("Caught: " + e), (Throwable)e);
        }
        catch (ReflectionException e) {
            log.warn((Object)("Caught: " + e), (Throwable)e);
        }
        return value;
    }
}

