/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.audit.lucene;

import java.io.IOException;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.servicemix.jbi.audit.AbstractAuditor;
import org.apache.servicemix.jbi.audit.AuditorException;
import org.apache.servicemix.jbi.audit.AuditorMBean;
import org.apache.servicemix.jbi.audit.AuditorQueryMBean;
import org.apache.servicemix.jbi.audit.lucene.DefaultLuceneCallback;
import org.apache.servicemix.jbi.audit.lucene.LuceneIndexer;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.event.ExchangeListener;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;

public class LuceneAuditor
extends AbstractAuditor
implements AuditorQueryMBean {
    private AuditorMBean delegatedAuditor;
    private LuceneIndexer luceneIndexer = new LuceneIndexer();

    protected void doStart() throws JBIException {
        super.doStart();
        if (this.delegatedAuditor == null) {
            throw new JBIException("A delegated auditor must be provided");
        }
        this.delegatedAuditor.start();
    }

    protected void doStop() throws JBIException {
        super.doStop();
        this.delegatedAuditor.stop();
    }

    public LuceneIndexer getLuceneIndexer() {
        return this.luceneIndexer;
    }

    public void setLuceneIndexer(LuceneIndexer luceneIndexer) {
        this.luceneIndexer = luceneIndexer;
    }

    public AuditorMBean getDelegatedAuditor() {
        return this.delegatedAuditor;
    }

    public void setDelegatedAuditor(AuditorMBean delegatedAuditor) {
        this.delegatedAuditor = delegatedAuditor;
        if (delegatedAuditor instanceof AbstractAuditor) {
            ((AbstractAuditor)delegatedAuditor).setAsContainerListener(false);
        }
    }

    public int getExchangeCount() throws AuditorException {
        return this.delegatedAuditor.getExchangeCount();
    }

    public String[] getExchangeIdsByRange(int fromIndex, int toIndex) throws AuditorException {
        return this.delegatedAuditor.getExchangeIdsByRange(fromIndex, toIndex);
    }

    public MessageExchange[] getExchangesByIds(String[] ids) throws AuditorException {
        return this.delegatedAuditor.getExchangesByIds(ids);
    }

    public int deleteExchangesByRange(int fromIndex, int toIndex) throws AuditorException {
        return this.delegatedAuditor.deleteExchangesByRange(fromIndex, toIndex);
    }

    public int deleteExchangesByIds(String[] ids) throws AuditorException {
        try {
            this.luceneIndexer.remove(ids);
        }
        catch (IOException io) {
            throw new AuditorException(io);
        }
        return this.delegatedAuditor.deleteExchangesByIds(ids);
    }

    public void exchangeSent(ExchangeEvent event) {
        MessageExchange exchange = event.getExchange();
        try {
            Document doc = this.createDocument(exchange);
            this.luceneIndexer.add(doc, exchange.getExchangeId());
            if (this.delegatedAuditor instanceof ExchangeListener) {
                ((ExchangeListener)this.delegatedAuditor).exchangeSent(event);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while adding to lucene", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Lucene Auditor";
    }

    public String[] findExchangesIDsByStatus(ExchangeStatus status) throws AuditorException {
        String field = "org.apache.servicemix.exchangestatus";
        return this.getExchangeIds(field, String.valueOf(status));
    }

    public String[] findExchangesIDsByMessageContent(String type, String content) throws AuditorException {
        String field = "org.apache.servicemix." + type + ".contents";
        return this.getExchangeIds(field, content);
    }

    public String[] findExchangesIDsByMessageProperty(String type, String property, String value) throws AuditorException {
        if (property != null && !property.startsWith("org.apache.servicemix")) {
            property = "org.apache.servicemix." + type + "." + property;
        }
        return this.getExchangeIds(property, value);
    }

    protected Document createDocument(MessageExchange me) throws MessagingException {
        try {
            SourceTransformer st = new SourceTransformer();
            Document d = new Document();
            d.add(Field.Keyword((String)"org.apache.servicemix.exchangeid", (String)me.getExchangeId()));
            d.add(Field.Keyword((String)"org.apache.servicemix.exchangestatus", (String)String.valueOf(me.getStatus())));
            String[] types = new String[]{"in", "out", "fault"};
            for (int i = 0; i < types.length; ++i) {
                String type = types[i];
                NormalizedMessage nm = me.getMessage(type);
                if (nm == null) continue;
                d.add(Field.UnStored((String)("org.apache.servicemix." + type + ".contents"), (String)st.contentToString(nm)));
                this.addMessagePropertiesToDocument(nm, d, type);
            }
            return d;
        }
        catch (MessagingException mse) {
            throw mse;
        }
        catch (Exception ex) {
            throw new MessagingException("Error while creating Lucene Document", (Throwable)ex);
        }
    }

    protected void addMessagePropertiesToDocument(NormalizedMessage nm, Document document, String type) throws MessagingException {
        Set propertyNames = nm.getPropertyNames();
        for (String propertyName : propertyNames) {
            Object value = nm.getProperty(propertyName);
            if (!(value instanceof String)) continue;
            document.add(Field.Keyword((String)("org.apache.servicemix." + type + "." + propertyName), (String)String.valueOf(value)));
        }
    }

    public String[] getExchangeIds(String queryContent, String field) throws AuditorException {
        DefaultLuceneCallback dfc = new DefaultLuceneCallback(queryContent, field);
        try {
            return (String[])this.luceneIndexer.search(dfc);
        }
        catch (IOException e) {
            throw new AuditorException("Error while getting Exchange IDs", e);
        }
    }
}

