/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.audit.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.audit.AbstractAuditor;
import org.apache.servicemix.jbi.audit.AuditorException;
import org.apache.servicemix.jbi.audit.file.FileAuditorStrategy;
import org.apache.servicemix.jbi.audit.file.TeeInputStream;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.util.FileUtil;
import org.apache.servicemix.jbi.util.MessageUtil;
import org.springframework.beans.factory.InitializingBean;

public class FileAuditor
extends AbstractAuditor
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(FileAuditor.class);
    private File directory;
    private FileAuditorStrategy strategy = new FileAuditorStrategyImpl();
    private boolean autostart = true;

    public void setDirectory(File directory) {
        if (!directory.exists()) {
            LOG.info((Object)("Creating directory " + directory));
            directory.mkdirs();
        }
        this.directory = directory;
    }

    public void exchangeSent(ExchangeEvent event) {
        try {
            MessageExchange exchange = event.getExchange();
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                OutputStream os = this.getOutputStream(exchange);
                this.writeFileHeader(os, exchange);
                NormalizedMessage in = exchange.getMessage("in");
                if (StreamSource.class.isAssignableFrom(in.getContent().getClass())) {
                    StreamSource original = (StreamSource)exchange.getMessage("in").getContent();
                    TeeInputStream tis = new TeeInputStream(original.getInputStream(), os);
                    exchange.getMessage("in").setContent((Source)new StreamSource(tis));
                } else {
                    MessageUtil.enableContentRereadability((NormalizedMessage)in);
                    SourceTransformer transformer = new SourceTransformer();
                    transformer.toResult(in.getContent(), (Result)new StreamResult(os));
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)String.format("Error occurred while storing message %s", event.getExchange().getExchangeId()), (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error((Object)String.format("Error occurred while storing message %s", event.getExchange().getExchangeId()), (Throwable)e);
        }
        catch (MessagingException e) {
            LOG.error((Object)String.format("Error occurred while storing message %s", event.getExchange().getExchangeId()), (Throwable)e);
        }
    }

    private void writeFileHeader(OutputStream os, MessageExchange exchange) {
        MessageExchangeWriter writer = new MessageExchangeWriter(os);
        writer.writeMessageExchange(exchange);
        writer.println();
        writer.println("-- Normalized message (in) --");
        writer.writeNormalizedMessage(exchange.getMessage("in"));
        writer.flush();
    }

    private OutputStream getOutputStream(MessageExchange exchange) throws FileNotFoundException {
        File file = new File(this.directory, this.strategy.getFileName(exchange));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public int deleteExchangesByIds(String[] ids) throws AuditorException {
        throw new AuditorException("deleteExchangesById(s) currently unsupported by FileAuditor");
    }

    public int getExchangeCount() throws AuditorException {
        return FileUtil.countFilesInDirectory((File)this.directory);
    }

    public String[] getExchangeIdsByRange(int fromIndex, int toIndex) throws AuditorException {
        throw new AuditorException("getExchangeIdsByRange currently unsupported by FileAuditor");
    }

    public MessageExchange[] getExchangesByIds(String[] ids) throws AuditorException {
        throw new AuditorException("getExchangeByIds currently unsupported by FileAuditor");
    }

    public String getDescription() {
        return "File-based auditing service";
    }

    public void afterPropertiesSet() throws Exception {
        this.init(this.getContainer());
        if (this.autostart) {
            this.start();
        } else {
            this.stop();
        }
    }

    private class FileAuditorStrategyImpl
    implements FileAuditorStrategy {
        private final DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");

        private FileAuditorStrategyImpl() {
        }

        public String getFileName(MessageExchange exchange) {
            return this.dateformat.format(new Date()) + File.separatorChar + exchange.getExchangeId().replaceAll("[:\\.]", "_");
        }
    }

    private final class MessageExchangeWriter
    extends PrintWriter {
        private MessageExchangeWriter(OutputStream os) {
            super(os);
        }

        private void writeMessageExchange(MessageExchange exchange) {
            this.println("-- Exchange " + exchange.getExchangeId() + " --");
            this.writeProperty("endpoint", exchange.getEndpoint());
            this.writeProperty("MEP", exchange.getPattern());
            for (Object key : exchange.getPropertyNames()) {
                this.writeProperty(key, exchange.getProperty(key.toString()));
            }
        }

        private void writeNormalizedMessage(NormalizedMessage message) {
            for (Object key : message.getPropertyNames()) {
                this.writeProperty(key, message.getProperty(key.toString()));
            }
            this.println();
            this.println("- content -");
        }

        private void writeProperty(Object key, Object value) {
            this.println(String.format(" %s : %s", key, value));
        }
    }
}

