/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean.support;

import javax.annotation.Resource;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.exception.FaultException;
import org.apache.servicemix.jbi.exception.NoInMessageAvailableException;
import org.apache.servicemix.jbi.helper.MessageHelper;
import org.apache.servicemix.jbi.transformer.CopyTransformer;
import org.apache.servicemix.jbi.transformer.MessageTransformer;

public abstract class BeanSupport {
    protected Log logger = LogFactory.getLog(this.getClass());
    @Resource
    private ComponentContext context;
    @Resource
    private DeliveryChannel channel;
    @Resource
    private ServiceEndpoint serviceEndpoint;
    private ObjectName extensionMBeanName;
    private MessageExchangeFactory exchangeFactory;
    private MessageTransformer messageTransformer = CopyTransformer.getInstance();

    protected BeanSupport() {
    }

    public Object getBody(NormalizedMessage message) throws MessagingException {
        return MessageHelper.getBody((NormalizedMessage)message);
    }

    public void setBody(NormalizedMessage message, Object body) throws MessagingException {
        MessageHelper.setBody((NormalizedMessage)message, (Object)body);
    }

    public ObjectName getExtensionMBeanName() {
        return this.extensionMBeanName;
    }

    public void setExtensionMBeanName(ObjectName extensionMBeanName) {
        this.extensionMBeanName = extensionMBeanName;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public MessageExchangeFactory getExchangeFactory() throws MessagingException {
        if (this.exchangeFactory == null && this.context != null) {
            this.exchangeFactory = this.getDeliveryChannel().createExchangeFactory();
        }
        return this.exchangeFactory;
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        if (this.channel == null) {
            this.channel = this.context.getDeliveryChannel();
        }
        return this.channel;
    }

    public void done(MessageExchange exchange) throws MessagingException {
        exchange.setStatus(ExchangeStatus.DONE);
        this.getDeliveryChannel().send(exchange);
    }

    public void send(MessageExchange exchange) throws MessagingException {
        this.getDeliveryChannel().send(exchange);
    }

    public boolean sendSync(MessageExchange exchange) throws MessagingException {
        return this.getDeliveryChannel().sendSync(exchange);
    }

    public boolean sendSync(MessageExchange exchange, long timeMillis) throws MessagingException {
        return this.getDeliveryChannel().sendSync(exchange, timeMillis);
    }

    public void answer(MessageExchange exchange, NormalizedMessage answer) throws MessagingException {
        exchange.setMessage(answer, "out");
        this.getDeliveryChannel().send(exchange);
    }

    public void fail(MessageExchange exchange, Fault fault) throws MessagingException {
        if (exchange instanceof InOnly || fault == null) {
            exchange.setError((Exception)new FaultException("Fault occured for in-only exchange", exchange, fault));
        } else {
            exchange.setFault(fault);
        }
        this.getDeliveryChannel().send(exchange);
    }

    public void fail(MessageExchange exchange, Exception error) throws MessagingException {
        if (exchange instanceof InOnly || !(error instanceof FaultException)) {
            exchange.setError(error);
        } else {
            FaultException faultException = (FaultException)error;
            exchange.setFault(faultException.getFault());
        }
        this.getDeliveryChannel().send(exchange);
    }

    protected boolean isInAndOut(MessageExchange exchange) {
        return exchange instanceof InOut || exchange instanceof InOptionalOut;
    }

    protected NormalizedMessage getInMessage(MessageExchange exchange) throws NoInMessageAvailableException {
        NormalizedMessage message = exchange.getMessage("in");
        if (message == null) {
            throw new NoInMessageAvailableException(exchange);
        }
        return message;
    }

    public MessageTransformer getMessageTransformer() {
        return this.messageTransformer;
    }

    public void setMessageTransformer(MessageTransformer transformer) {
        this.messageTransformer = transformer;
    }

    public void invoke(MessageExchange exchange, NormalizedMessage in, QName service, QName interfaceName, QName operation) throws MessagingException {
        InOnly outExchange = this.createInOnlyExchange(service, interfaceName, operation);
        this.forwardToExchange(exchange, outExchange, in, operation);
    }

    public InOnly createInOnlyExchange(QName service, QName interfaceName, QName operation) throws MessagingException {
        MessageExchangeFactory factory = null;
        factory = service != null ? this.getDeliveryChannel().createExchangeFactoryForService(service) : (interfaceName != null ? this.getDeliveryChannel().createExchangeFactory(interfaceName) : this.getExchangeFactory());
        InOnly outExchange = factory.createInOnlyExchange();
        if (service != null) {
            outExchange.setService(service);
        }
        if (interfaceName != null) {
            outExchange.setInterfaceName(interfaceName);
        }
        if (operation != null) {
            outExchange.setOperation(operation);
        }
        return outExchange;
    }

    public InOnly createInOnlyExchange(QName service, QName interfaceName, QName operation, MessageExchange beforeExchange) throws MessagingException {
        InOnly inOnly = this.createInOnlyExchange(service, interfaceName, operation);
        this.propagateCorrelationId(beforeExchange, (MessageExchange)inOnly);
        return inOnly;
    }

    public InOut createInOutExchange(QName service, QName interfaceName, QName operation) throws MessagingException {
        MessageExchangeFactory factory = null;
        factory = service != null ? this.getDeliveryChannel().createExchangeFactoryForService(service) : (interfaceName != null ? this.getDeliveryChannel().createExchangeFactory(interfaceName) : this.getExchangeFactory());
        InOut outExchange = factory.createInOutExchange();
        if (service != null) {
            outExchange.setService(service);
        }
        if (interfaceName != null) {
            outExchange.setInterfaceName(interfaceName);
        }
        if (operation != null) {
            outExchange.setOperation(operation);
        }
        return outExchange;
    }

    public InOut createInOutExchange(QName service, QName interfaceName, QName operation, MessageExchange srcExchange) throws MessagingException {
        InOut inOut = this.createInOutExchange(service, interfaceName, operation);
        this.propagateCorrelationId(srcExchange, (MessageExchange)inOut);
        return inOut;
    }

    public InOnly createInOnlyExchange(MessageExchange srcExchange) throws MessagingException {
        MessageExchangeFactory factory = this.getExchangeFactory();
        InOnly inOnly = factory.createInOnlyExchange();
        this.propagateCorrelationId(srcExchange, (MessageExchange)inOnly);
        return inOnly;
    }

    public InOptionalOut createInOptionalOutExchange(MessageExchange srcExchange) throws MessagingException {
        MessageExchangeFactory factory = this.getExchangeFactory();
        InOptionalOut inOptionalOut = factory.createInOptionalOutExchange();
        this.propagateCorrelationId(srcExchange, (MessageExchange)inOptionalOut);
        return inOptionalOut;
    }

    public InOut createInOutExchange(MessageExchange srcExchange) throws MessagingException {
        MessageExchangeFactory factory = this.getExchangeFactory();
        InOut inOut = factory.createInOutExchange();
        this.propagateCorrelationId(srcExchange, (MessageExchange)inOut);
        return inOut;
    }

    public RobustInOnly createRobustInOnlyExchange(MessageExchange srcExchange) throws MessagingException {
        MessageExchangeFactory factory = this.getExchangeFactory();
        RobustInOnly robustInOnly = factory.createRobustInOnlyExchange();
        this.propagateCorrelationId(srcExchange, (MessageExchange)robustInOnly);
        return robustInOnly;
    }

    public void propagateCorrelationId(MessageExchange source, MessageExchange dest) {
        if (source == null || dest == null) {
            return;
        }
        String correlationId = (String)source.getProperty("org.apache.servicemix.correlationId");
        if (correlationId != null) {
            dest.setProperty("org.apache.servicemix.correlationId", (Object)correlationId);
        } else {
            dest.setProperty("org.apache.servicemix.correlationId", (Object)source.getExchangeId());
        }
    }

    protected void forwardToExchange(MessageExchange exchange, InOnly outExchange, NormalizedMessage in, QName operationName) throws MessagingException {
        if (operationName != null) {
            exchange.setOperation(operationName);
        }
        this.forwardToExchange(exchange, outExchange, in);
    }

    protected void forwardToExchange(MessageExchange exchange, InOnly outExchange, NormalizedMessage in) throws MessagingException {
        NormalizedMessage out = outExchange.createMessage();
        outExchange.setInMessage(out);
        this.getMessageTransformer().transform(exchange, in, out);
        this.getDeliveryChannel().send((MessageExchange)outExchange);
    }

    protected QName getService() {
        QName service = null;
        if (this.serviceEndpoint != null) {
            service = this.serviceEndpoint.getServiceName();
        }
        return service;
    }

    protected String getEndpoint() {
        String endpoint = null;
        if (this.serviceEndpoint != null) {
            endpoint = this.serviceEndpoint.getEndpointName();
        }
        return endpoint;
    }
}

